# -*- coding: utf-8 -*-

import os
import datetime
import io
import logging


class Reader(object):
    '''
    Класс для итеративного чтения из файлов.
    '''

    def __init__(self, positioner, parser):
        self.positioner = positioner
        self.parser = parser

    def read(self, logpath):
        try:
            logfd = open(logpath)
        except:
            return

        positions = self.positioner.load_positions().get(logpath, {})
        if positions.get('inode') != os.fstat(logfd.fileno()).st_ino:
            positions = {}

        if 'position' in positions:
            pos = positions['position']
            logfd.seek(pos)
        else:
            logfd.seek(0, io.SEEK_END)
            pos = logfd.tell()
            self.positioner.save_positions(logfd, datetime.datetime.now())

        portion = {
            'datetime': None,
            'parsed_lines': [],
            'position': pos,
        }

        while True:
            line = logfd.readline()

            if not line:
                break

            try:
                data = self.parser.parse(line)
            except Exception as e:
                logging.warning("Unrecognized line:\n%s:%s\n" % (line, repr(e)))
                continue

            group_dt = self.parser.get_group_datetime(data['datetime'])

            if group_dt == portion['datetime']:
                portion['parsed_lines'].append(data)
                portion['position'] = logfd.tell()

            else:
                dtime = portion['datetime']

                if portion['parsed_lines']:
                    yield (portion['datetime'], portion['parsed_lines'])
                    self.positioner.save_positions(logfd, dtime)

                # до конца данные за этот период ещё не записаны
                if group_dt == self.parser.get_group_datetime(datetime.datetime.now()):
                    break

                portion = {
                    'datetime': group_dt,
                    'parsed_lines': [data],
                    'position': logfd.tell(),
                }
