#!/bin/bash -e

CONFDIR="/etc/clicktail"
CHPASS=`/bin/cat /etc/direct-tokens/clickhouse_direct_monitor`
ENVTYPE=`echo -n $(/bin/cat /etc/yandex/environment.type)`

if [ -f /etc/direct-tokens/mysql_advmon ]
then
	MYPASS=`/bin/cat /etc/direct-tokens/mysql_advmon`
elif [ -f /etc/direct-tokens/mysql.sandbox_advmon ]
then
	MYPASS=`/bin/cat /etc/direct-tokens/mysql.sandbox_advmon`
elif [ -f /etc/direct-tokens/mysql_advmon_testing ]
then
	MYPASS=`/bin/cat /etc/direct-tokens/mysql_advmon_testing`
else
	MYPASS=""
fi

function installRunit {
	FILE="/etc/sv/clicktail-$i/run"
	[ -f $FILE ] && return
	/bin/mkdir /etc/sv/clicktail-$i ||:
	/bin/cp /var/lib/clicktail/clicktail.sv.template $FILE ||:
	/bin/sed -i "s/INSTANCE/$i/g" $FILE ||:
	/bin/chmod +x $FILE ||:
	return
}

function runRunit {
	[ -L /etc/service/clicktail-$i ] && return
	/bin/ln -s /etc/sv/clicktail-$i /etc/service/clicktail-$i
}

function installRunitLog {
	FILE="/etc/sv/clicktail-$i/log/run"
	[ -f $FILE ] && return
	/bin/mkdir /etc/sv/clicktail-$i/log ||:
	/bin/cp /var/lib/clicktail/clicktail.sv.log.template $FILE ||:
	/bin/sed -i "s/INSTANCE/$i/g" $FILE ||:
	/bin/chmod +x $FILE ||:
	return
}

function installConfig {
	FILE="$CONFDIR/$i.conf"
	[ -f $FILE ] && /usr/bin/touch $FILE && return
	/bin/cp /var/lib/clicktail/clicktail.conf.template $FILE ||:
	if [ $ENVTYPE = "production" ]
	then
		CHADDR="ppchouse-cloud.direct.yandex.net:8443"
		CHTABLE="monitor.mysql_slow_log_mergetree"
		CHPROTO="https"
	else
		CHADDR="man-ivwlnuip3uudyaqs.db.yandex.net:8443"
		CHTABLE="monitor.mysql_slow_log_testing_mergetree"
		CHPROTO="https"
	fi
	/bin/sed -i "s/CHADDR/$CHADDR/g" $FILE
	/bin/sed -i "s/CHTABLE/$CHTABLE/g" $FILE
	/bin/sed -i "s/INSTANCE/$i/g" $FILE
	/bin/sed -i "s/CHUSER/direct_monitor/g" $FILE
	/bin/sed -i "s/CHPASS/$CHPASS/g" $FILE
	/bin/sed -i "s/CHPROTO/$CHPROTO/g" $FILE
	/bin/sed -i "s/MYUSER/advmon/g" $FILE
	/bin/sed -i "s/MYPASS/$MYPASS/g" $FILE
}

function cleaning {
	/bin/rm $i ||:
	instance=`/usr/bin/basename $i | sed 's/.conf//g'`
	/usr/bin/sv stop clicktail-$instance ||:
	/bin/rm /etc/service/clicktail-$i ||:
	/bin/rm /etc/sv/clicktail-$instance/run ||:
	/bin/rm /etc/sv/clicktail-$instance/log/run ||:
	/bin/rmdir /etc/sv/clicktail-$instance/log ||:
	/bin/rmdir /etc/sv/clicktail-$instance ||:
}

[ ! -d $CONFDIR ] && /bin/mkdir $CONFDIR;
/bin/chown clicktail $CONFDIR;

for i in `/usr/local/bin/lm --complete`; do
	installRunit
	installConfig
	installRunitLog
	runRunit
done

for i in `/bin/readlink -f $CONFDIR/*`; do
	CURTIME=`/bin/date +"%s"`
	FILETIME=`/usr/bin/stat -c "%Y" $i`
	[ $(($CURTIME-$FILETIME)) -ge 600 ] && cleaning
done
