package sshrequest

import (
	"fmt"
	"io/ioutil"
	"os"

	"golang.org/x/crypto/ssh"
)

func MakeSigner(sshKey string) (signer ssh.Signer, err error) {
	var fd *os.File
	if fd, err = os.Open(sshKey); err != nil {
		return nil, err
	}
	defer func() { _ = fd.Close() }()

	var sshValue []byte
	if sshValue, err = ioutil.ReadAll(fd); err != nil {
		return nil, err
	}

	signer, err = ssh.ParsePrivateKey(sshValue)
	return
}

func MakeKeyring() ssh.AuthMethod {
	var signer ssh.Signer
	var err error
	signers := []ssh.Signer{}
	sshKeys := []string{}

	if len(os.Getenv("SSHKEY")) > 0 {
		sshKeys = append(sshKeys, os.Getenv("SSHKEY"))
	} else {
		sshKeys = append(sshKeys, os.Getenv("HOME")+"/.ssh/id_rsa", os.Getenv("HOME")+"/.ssh/id_dsa")
	}
	for _, sshKey := range sshKeys {
		if signer, err = MakeSigner(sshKey); err == nil {
			signers = append(signers, signer)
		} else {
			msg := fmt.Errorf("error ssh connect: %s", err)
			fmt.Println(msg)
		}
	}
	return ssh.PublicKeys(signers...)
}

func PrepareSSHConnect() (sshConfig *ssh.ClientConfig) {
	sshConfig = &ssh.ClientConfig{
		User:            os.Getenv("LOGNAME"),
		Auth:            []ssh.AuthMethod{MakeKeyring()},
		HostKeyCallback: ssh.InsecureIgnoreHostKey(),
	}
	sshConfig.SetDefaults()
	return
}
