package support

import "testing"

//проверяем удаление 2 хостов
func TestRemoveHost(t *testing.T) {
	hosts := NewHosts()
	removed := NewHosts()
	for _, hostname := range []string{"host1", "host2", "host3", "host4", "host5"} {
		host := NewHost(hostname, "group1")
		*hosts = append(*hosts, host)
		if hostname == "host2" || hostname == "host4" {
			*removed = append(*removed, host)
		}
	}
	hosts.RemoveHost(*removed)

	if len(*hosts) != 3 {
		t.Error("В результате удаления должно остаться 3 хоста, сейчас это не так", *removed, *hosts)
	}
	for _, rh := range *removed {
		if (*hosts).HasHost(rh) {
			t.Error("В результате удаления не был удален нужный хост", rh, *hosts)
		}
	}
}
