package support

import "log/syslog"

type YtReplicators map[GroupName]YtReplicator

type Config struct {
	ZookeeperServers []string       `yaml:"zookeeper_servers"`
	ZookeeperPath    string         `yaml:"zookeeper_path"`
	ListenPort       int            `yaml:"listen_port"`
	ListenHost       string         `yaml:"listen_server"`
	Logger           *syslog.Writer `yaml:"-"`
	Replicators      YtReplicators  `yaml:"replicators"`
	TeleportHosts    Servers        `yaml:"teleport_hosts" json:"teleport_hosts"`
	MysqlTokenFile   string         `yaml:"mysql_token_file" json:"mysql_token_file"`
	MysqlUser        string         `yaml:"mysql_user" json:"mysql_user"`
}

type YtReplicator struct {
	SourceCluster      string  `yaml:"src_cluster" json:"src_cluster"`
	DestinationCluster string  `yaml:"dst_cluster" json:"dst_cluster"`
	SourceDir          string  `yaml:"src_directory" json:"src_directory"`
	DestinationDir     string  `yaml:"dst_directory" json:"dst_directory"`
	Account            string  `yaml:"account"`
	YTTokenFile        string  `yaml:"token_file" json:"token_file"`
	ReplicatorHosts    Servers `yaml:"replicator_hosts" json:"replicator_hosts"`
	Error              *error  `yaml:"-" json:"-"`
	WriterHosts        Servers `yaml:"binlogwriter_hosts" json:"binlogwriter_hosts"`
	WriterYTCluster    string  `yaml:"binlogwriter_cluster" json:"binlogwriter_cluster" `
	WriterYTDir        string  `yaml:"binlogwriter_directory" json:"binlogwriter_directory" `
}

type Group string
type Groups []Group
type GroupName string
