package yttransfer

import (
	"encoding/json"
	"fmt"
	"testing"
)

func TestCheckYtTaskStatus(t *testing.T) {
	var ym YtMetaTestData
	var tss YtTransferTasks

	for i := 0; i > 3; i++ {
		tt := NewYtTransferTable(ym, "backup1", fmt.Sprintf("%d", i), ReplicatorVersion("v.12"))
		ts := NewYtTransferTask(tt)
		startData := "{\"state_description\": \"Completed\", \"destination_table\": \"//home/direct/test/mysql-sync/dev7test/v.13/mysql-sync-states_static\", " +
			"\"source_table\": \"//home/direct/mysql-sync-backup/2019-10-30/mysql-sync-states_static\", \"creation_time\": \"2019-10-31T16:03:10.293435Z\", " +
			"\"destination_cluster\": \"zeno\", \"id\": \"7676130f-96827690-e0447505-1bac1abc\", \"state\": \"completed\", " +
			"\"source_cluster\": \"hahn\", \"progress\": {\"operations\": [{\"cluster_name\": \"zeno\", \"type\": \"yt\", \"id\": \"8d30e1ac-c060053d-40903e8-ca0951af\"}], " +
			"\"transactions\": [{\"cluster_name\": \"zeno\", \"id\": \"8b0d-2a708-4090001-a81cc0c7\"}]}, \"backend_tag\": \"production\", " +
			" \"copy_method\": \"native\", \"pack_yson_bindings\": true, \"start_time\": \"2019-10-31T16:03:12.381457Z\", \"user\": \"robot-direct-yt-test\", " +
			"\"pool\": \"transfer_hahn\", \"finish_time\": \"2019-10-31T16:03:30.237487Z\", \"pack_yt_wrapper\": true}"

		if err := json.Unmarshal([]byte(startData), &ts); err != nil {
			t.Errorf("ошибка unmarshal: %s", err)
		}
		ts.SetLastError("error1")
		tss = append(tss, &ts)
	}

	if !tss.CheckAllTasksDone() {
		t.Errorf("не все статусы равны true")
	}
}

type YtMetaTestData string

func (y YtMetaTestData) GetSourceDirectory() string {
	return "//srcdir"
}

func (y YtMetaTestData) GetDestinationDirectory() string {
	return "//dstdir"
}

func (y YtMetaTestData) GetSourceCluster() string {
	return "srcyt"
}

func (y YtMetaTestData) GetDestinationCluster() string {
	return "dstyt"
}
