package main

import (
	"crypto/tls"
	"fmt"
	"io/ioutil"
	"net/http"
	"net/url"
	"time"

	cloud "a.yandex-team.ru/direct/infra/dt-haproxy-cloud/internal/cloudapi"
	"a.yandex-team.ru/direct/infra/dt-haproxy-cloud/internal/config"
)

//Проверяем обновление хостов в пуле, а так же возможность подключения по http/https
func RunAliveChecks(pool cloud.StatusHosts, cnf config.Config, astat *cloud.AliveStatus) {
	t := time.NewTicker(10 * time.Second)
	for range t.C {
		*astat.ModifyTime = time.Now()
		*astat.LastErrors = aliveChecks(pool, cnf)
	}
}

func aliveChecks(pool cloud.StatusHosts, cnf config.Config) error {
	if ok, err := checkAliveClusterPool(pool); !ok {
		return fmt.Errorf("error check AlivePool: %s", err)
	}
	if ok, err := checkAliveDB(config.CHHTTPS, cnf); !ok {
		return fmt.Errorf("error check AliveHTTPSPort/%d: %s", config.CHHTTPS, err)
	}
	if ok, err := checkAliveDB(config.ROHTTPS, cnf); !ok {
		return fmt.Errorf("error check AliveHTTPSPort/%d: %s", config.ROHTTPS, err)
	}
	return nil
}

//monitoring update pool hosts
func checkAliveClusterPool(pool cloud.StatusHosts) (bool, error) {
	mtime := pool.LastModifyTime()
	if mtime == 0 {
		return false, fmt.Errorf("empty pool")
	}
	dtime := time.Since(time.Unix(mtime, 0))
	if dtime > time.Duration(5*time.Minute) {
		return false, fmt.Errorf("old ModifyTime in pool. Duration: %d", dtime)
	}
	return true, nil
}

//monitorig working chport
func checkAliveDB(port int, cnf config.Config) (bool, error) {
	client := &http.Client{
		Timeout: 5 * time.Second,
	}
	caCertPool, err := cloud.CreateCertPool(cloud.CAINTERNAL)
	if err != nil {
		return false, err
	}

	mytls := &tls.Config{
		RootCAs:            caCertPool,
		InsecureSkipVerify: true,
	}
	client.Transport = &http.Transport{
		TLSClientConfig: mytls,
	}

	var req *http.Request

	form := url.Values{
		"database": {cnf.Database},
		"query":    {"SELECT NOW()"},
	}

	address := fmt.Sprintf("https://localhost:%d/?%s", port, form.Encode())
	req, err = http.NewRequest("GET", address, nil)
	if err != nil {
		return false, err
	}
	req.Header.Set("X-ClickHouse-User", cnf.User)
	req.Header.Set("X-ClickHouse-Key", *cnf.Password)

	fmt.Printf("%+v REQ %s", req, req.URL)
	resp, err := client.Do(req)
	if err != nil {
		return false, fmt.Errorf("error run request: %s", err)
	}
	defer func() { _ = resp.Body.Close() }()
	data, _ := ioutil.ReadAll(resp.Body)
	if resp.StatusCode != 200 {
		return false, fmt.Errorf("error status code: %d %s", resp.StatusCode, data)
	}
	if len(data) == 0 {
		return false, fmt.Errorf("empty response request SELECT NOW()")
	}
	return true, nil
}
