package main

import (
	"fmt"
	"io"
	"math/rand"
	"net"
	"sync"
	"time"

	cloud "a.yandex-team.ru/direct/infra/dt-haproxy-cloud/internal/cloudapi"
	"a.yandex-team.ru/direct/infra/dt-haproxy-cloud/internal/config"
	"a.yandex-team.ru/direct/infra/dt-haproxy-cloud/internal/mylog"
)

func StartNativeProxy(pool cloud.ActivePool, port int) {
	address := fmt.Sprintf(":%d", port)
	var incoming net.Listener

	go func(ap *cloud.ActivePool, in *net.Listener) {
		for {
			if len((*ap).ActivePool().Hostnames()) == 0 {
				mylog.Warn("empty %s ready hosts: %v, all hosts: %v", pool.Group(), (*ap).ActivePool(), (*ap).AllPool())
				if *in != nil {
					_ = (*in).Close()
					*in = nil
				}
			} else if *in == nil {
				*in, err = net.Listen("tcp", address)
				if err != nil {
					mylog.Warn("could not start server on %s: %s", address, err)
				}
			}
			time.Sleep(5 * time.Second)
		}
	}(&pool, &incoming)

	for {
		if incoming == nil {
			time.Sleep(2 * time.Second)
			mylog.Warn("error incoming connect: nil")
			continue
		}
		conn, err := incoming.Accept()
		if err != nil {
			mylog.Warn("error incoming connect: %s", err)
			continue
		}
		go RunProxy(conn, pool, port)
	}

	/*старый кусок данных, который потом удалю
	in, err := net.Listen("tcp", address)
	if err != nil {
		mylog.Warn("could not start server on %s: %s", address, err)
		return
	}
	for {
		if len(pool.ActivePool().Hostnames()) == 0 {
			mylog.Warn("empty %s ready hosts: %v, all hosts: %v", pool.Group(), pool.ActivePool(), pool.AllPool())
		}
		conn, err := in.Accept()
		if err != nil {
			mylog.Warn("error incoming connect: %s", err)
			continue
		}
		go RunProxy(conn, pool, port)
	}*/
}

func RunProxy(conn net.Conn, pool cloud.ActivePool, port int) {
	hosts := pool.ActivePool().Hostnames()
	if len(hosts) == 0 {
		mylog.Warn("empty %s active hosts: %v, all hosts: %v", pool.Group(), pool.ActivePool(), pool.AllPool())
		_ = conn.Close()
		return
	}

	rand.Seed(time.Now().Unix())
	i := rand.Intn(len(hosts))

	if port == config.ROHTTPS {
		port = config.CHHTTPS
	}

	address := fmt.Sprintf("%s:%d", hosts[i].ToString(), port)
	mylog.Debug("proxy %v connect to %s", conn.RemoteAddr(), address)

	proxy, err := net.DialTimeout("tcp", address, 60*time.Second)
	if err != nil {
		mylog.Warn("error incoming connect: %s", err)
		_ = conn.Close()
		return
	}
	mylog.Debug("success dial %s from %s", proxy.RemoteAddr(), conn.RemoteAddr())
	start := time.Now()
	var wg sync.WaitGroup
	wg.Add(1)
	go CopyIO(conn, proxy, &wg)
	wg.Add(1)
	go CopyIO(proxy, conn, &wg)
	defer func() { _ = conn.Close() }()
	defer func() { _ = proxy.Close() }()
	defer func() {
		delta := time.Since(start)
		mylog.Debug("write duration time(%s->%s) %s ", conn.RemoteAddr(), address, delta)
	}()
	wg.Wait()
}

func CopyIO(src, dest net.Conn, wg *sync.WaitGroup) {
	defer (*wg).Done()
	if _, err = io.Copy(src, dest); err == nil {
		return
	} else if err == io.EOF {
		mylog.Debug("closed connection %s", err)
	} else {
		mylog.Debug("error %+v\n", err)
	}
}
