package main

import (
	"database/sql"
	"strings"
	"syscall"
	"time"

	"a.yandex-team.ru/direct/infra/dt-haproxy-cloud/internal/cloudapi"
	"a.yandex-team.ru/direct/infra/dt-haproxy-cloud/internal/mylog"
)

//запрос на подсчет места, занимаемого данными в CH
var request1 string = "SELECT table, sum(bytes_on_disk) AS used FROM system.parts GROUP BY table"

//запрос пока не используется, но через него можно получать списки detached кусочков.
var request2 string = "SELECT table, count(*) AS count FROM system.detached_parts GROUP BY table"

func UpdateStatusHosts(cluster cloudapi.ClusterHosts, pool cloudapi.StatusHosts) {
	ticker := time.NewTicker(5 * time.Second)
	for range ticker.C {
		for _, host := range *cluster.Hosts {
			//пропускаем zookeeper
			if host.Type == "ZOOKEEPER" {
				continue
			}
			if _, ok := pool[host.Name]; !ok {
				var conn sql.DB
				pool[host.Name] = cloudapi.NewStatusHost(host, &conn)
			} else {
				*pool[host.Name].ClusterHost = host
			}
		}

		//список имен машин
		hostnames := cluster.Hostnames()
		for host, value := range pool {
			if !hostnames.HasHost(host) {
				delete(pool, host)
				continue
			}
			//пропускаем мертвые машины
			if !strings.Contains(strings.ToUpper(value.Health), "ALIVE") && len(value.Health) != 0 {
				mylog.Crit("host %s are died, cluster health: %s\n", host, value.Health)
				*pool[host].Status = "SKIP"
				continue
			}
			*pool[host].Status = "OK"
		}
	}
}

//Проверяет хосты на наличие новых или удаленных. Если таковые имеются - то отправляется HUP сигнал самому себе.
func MonitoringReadyHosts(pool cloudapi.StatusHosts) {
	var readyHosts []cloudapi.ActivePool

	readyHosts = append(readyHosts, cloudapi.NewMySQLAliveHosts(pool, "write"))

	ticker := time.NewTicker(10 * time.Second)
	for range ticker.C {
		sendHup := false
		for _, readyHost := range readyHosts {
			var removed, added cloudapi.Hostnames
			currentMasters := readyHost.ActivePool().Masters()
			for _, h1 := range currentMasters.Hostnames() {
				if !readyHost.LastPool().HasHost(h1) {
					added = append(added, h1)
				}
			}
			lastMasters := readyHost.LastPool().Masters()
			for _, h1 := range lastMasters.Hostnames() {
				if !currentMasters.HasHost(h1) {
					removed = append(removed, h1)
				}
			}
			readyHost.SetLastPool(readyHost.ActivePool())

			mylog.Debug("current %v hosts: %v\n", readyHost.Group(), currentMasters)
			mylog.Debug("last hosts: %v\n", currentMasters)
			if len(removed) > 0 {
				mylog.Notice("deleted %s hosts: %v\n", readyHost.Group(), removed)
			}
			if len(added) > 0 {
				mylog.Notice("added %s hosts: %v\n", readyHost.Group(), added)
			}

			if len(removed) > 0 || len(added) > 0 {
				sendHup = true
			}
		}

		if sendHup {
			err := syscall.Kill(syscall.Getpid(), syscall.SIGHUP)
			if err != nil {
				mylog.Crit("error send HUP signal: %s\n", err)
			}
		}
	}
}
