package cloudapi

import (
	"crypto/x509"
	"fmt"
	"io/ioutil"
)

const (
	CAINTERNAL = "/usr/share/yandex-internal-root-ca/YandexInternalRootCA.crt"
	CAEXTERNAL = ""
)

//загружает CA сертификат из cloud key файла
func CreateCertPool(cacert string) (pool *x509.CertPool, err error) {
	if len(cacert) == 0 {
		return x509.SystemCertPool()
	}

	pool = x509.NewCertPool()
	ca, err := ioutil.ReadFile(cacert)
	if err != nil {
		err = fmt.Errorf("error read file %s: %s", cacert, err)
		return
	}
	pool.AppendCertsFromPEM(ca)
	return
}
