package mylog

import (
	"fmt"
	"log"
	"log/syslog"
	"os"
	"path/filepath"
)

var logger *syslog.Writer
var debug bool

func LoadRsyslogConfig() {
	var priority syslog.Priority
	var err error
	value, ok := os.LookupEnv("DEBUG")
	if ok && value == "true" {
		debug = true
	}
	priority = syslog.LOG_LOCAL3 | syslog.LOG_DEBUG
	if logger, err = syslog.New(priority, filepath.Base(os.Args[0])); err != nil {
		log.Fatalf("error start syslog: %s", err)
	}
}

func Crit(val string, arg ...interface{}) {
	msg := fmt.Sprintf(val, arg...)
	wrap(logger.Crit(msg))
}

func Debug(val string, arg ...interface{}) {
	if debug {
		msg := fmt.Sprintf(val, arg...)
		wrap(logger.Debug(msg))
	}
}

func Notice(val string, arg ...interface{}) {
	msg := fmt.Sprintf(val, arg...)
	wrap(logger.Notice(msg))
}

func Warn(val string, arg ...interface{}) {
	msg := fmt.Sprintf(val, arg...)
	wrap(logger.Warning(msg))
}

func wrap(err error) {
	if err != nil {
		fmt.Println(err)
	}
}
