#!/usr/bin/env python
# *-* encoding: utf-8 *-*

import os
import time
import datetime
import argparse
import logging
import sys

from subprocess import Popen

USAGE = '''Программа обертка для переноса пользователей из старой среды ТС в новую
./teleport.py -g dev7 -u yndx.dspushkin.superreader export
./teleport.py -g dev7 -p /tmp/tmp_teleport_20203920 import
'''

USERS_SVN = "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/direct/infra/dt-teleport/etc/yandex/dt-teleport"
DIRECT_SVN = "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/direct/perl/protected"
SCHEMA_SVN = "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/direct/perl/db_schema"
LAYOUT_SVN = "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/direct/perl/layout"
SETTINGS_SVN = "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/direct/perl/perl"

USERS_FILE = "dt-teleport/userslist"
SCHEMA_CWD = "db_schema/ppc"
SCHEMA_FILE = "dbschema.list"

EXPORTCMD = "./protected/maintenance/export_client_data.pl --dir {sqldir} --login {user}  --sort-list {dbschema}"
#IMPORTCMD = "./protected/maintenance/import_client_data.pl --move-existing-to-next-shard --replace-existing --dir {sqldir}"
IMPORTCMD = "./protected/maintenance/import_client_data.pl --replace-existing --dir {sqldir}"

SCHEMA_CMD = '''/bin/grep FK *.text | /usr/bin/perl -lne '/^(.*?)\.text.*FK\((?:ppc\.)?(.*?)\./ or next; $first = $2; $next = $1; next if $first eq "ppcdict"; print "$first $next";' | grep -vE '^(users clients|banners phrases|wallet_campaigns campaigns|campaigns_deals deals)$' | /usr/bin/tsort | xargs | sed 's/ /,/g' '''

ENVS = {
    "dev7": {"SETTINGS_LOCAL_SUFFIX": "Dev7"},
    "test": {"SETTINGS_LOCAL_SUFFIX": "Test"},
    "test2": {"SETTINGS_LOCAL_SUFFIX": "Test2"},
    "devtest": {"SETTINGS_LOCAL_SUFFIX": "DevTest"},
    "prod": {"SETTINGS_LOCAL_SUFFIX": "ROProd"},
}

global group

#логирование осуществляется в STDOUT/STDERR
def startLogging(level='DEBUG'):
    logger = logging.getLogger('stream logs to console')
    logger.setLevel(level=getattr(logging, level))
    formatter = logging.Formatter('%(asctime)s %(message)s')
    logch = logging.StreamHandler()
    logch.setLevel(level=getattr(logging, level))
    logch.setFormatter(formatter)
    logger.addHandler(logch)
    return logger, logch

#Принимает команду на выполнение.
#В результате выводит статус выполнения(true/false) и ошибку(error).
def runMysqlShellCommand(command, cwd=None, env=None, stdout=None):
    cwd = os.getcwd() if cwd is None else cwd
    try:
        logger.debug("run command {0} cwd {1}".format(command, cwd))
        fileno_logfile = logch.stream.fileno()
        stdout = fileno_logfile if stdout is None else stdout
        p1 = Popen(command, shell=True, bufsize=0, cwd=cwd, stderr=fileno_logfile, stdout=stdout, env=env)
        while True:
            rcode1 = p1.poll()
            if rcode1 is not None and rcode1 != 0:
                raise ValueError("error run command {0} code {1}".format(command, rcode1))
            if rcode1 == 0:
                break
            p1.wait()
    except Exception as err:
        return False, ValueError("error command {0}: {1}", command, err)
    return True, None

def makeTmpDir():
    mytime = datetime.datetime.fromtimestamp(time.time())
    tmpdir = "/tmp/tmp_teleport_{0}".format(mytime.strftime("%Y%M%d"))
    logger.info("make tmp dir {0}".format(tmpdir))
    if not os.path.exists(tmpdir):
        os.mkdir(tmpdir)
        logger.debug("create dir {0}".format(tmpdir))
    lockdir = os.path.join(tmpdir, "protected/run")
    if not os.path.exists(lockdir):
        os.makedirs(lockdir)
        logger.debug("create dir {0}".format(lockdir))
    logdir = os.path.join(tmpdir, "protected/logs")
    if not os.path.exists(logdir):
        os.makedirs(logdir)
        logger.debug("create dir {0}".format(logdir))
    return tmpdir

def runExport(userlist, archive, revision):
    tmpdir = makeTmpDir() if len(archive) == 0 else archive
    updateTeleport(tmpdir, userlist, revision)
    updateDBSchema(tmpdir)
    exportTeleport(tmpdir)

def runImport(archive):
    importTeleport(archive)

def updateDBSchema(tmpdir):
    logger.info("start update dbschema")
    dbschema_file = os.path.join(tmpdir, SCHEMA_FILE)
    with open(dbschema_file, 'w') as fd:
        logger.debug("write dbschema to file {0}".format(dbschema_file))
        ok, err = runMysqlShellCommand(command=SCHEMA_CMD, cwd=os.path.join(tmpdir, SCHEMA_CWD), env=None, stdout=fd.fileno())
    if not ok:
        logger.critical("failed update dbschema: {0}".format(err))
        raise ValueError(err)
    if os.stat(dbschema_file).st_size == 0:
        err = "zero size file {0}".format(dbschema_file)
        logger.critical(err)
        raise ValueError(err)
    logger.info("success update dbschema")

def exportTeleport(tmpdir):
    dbschema_file = os.path.join(tmpdir, SCHEMA_FILE)
    dbschema_list = open(dbschema_file).read().strip()
    users_file = os.path.join(tmpdir, USERS_FILE)
    users_list = open(users_file).read().strip().split("\n")
    sqldir = os.path.join(tmpdir, "sql_{0}".format(group))
    if not os.path.exists(sqldir):
        os.mkdir(sqldir)
    if len(users_list) == 0:
        err = "empty export login list"
        logger.critical(err)
        raise ValueError(err)
    for user in users_list:
        args = {
            "dbschema": dbschema_list,
            "user": user,
            "sqldir": sqldir
        }
        ok, err = runMysqlShellCommand(command=EXPORTCMD.format(**args), cwd=os.path.join(tmpdir), env=ENVS.get(group))
        if not ok:
            logger.critical("failed export user {0}: {1}".format(user, err))
        else:
            logger.info("success export user {0}".format(user))
    logger.info("finish export teleport to {0}".format(tmpdir))

def importTeleport(tmpdir):
    exports = [ i for i in os.listdir(tmpdir) if i.startswith("sql_") ]
    logger.info("import clients for {0}".format(exports))
    for iname in exports:
        sqldir = os.path.join(tmpdir, iname)
        args = {
            "sqldir": sqldir
        }
	logger.info("import {0}".format(sqldir))
        ok, err = runMysqlShellCommand(command=IMPORTCMD.format(**args), cwd=os.path.join(tmpdir), env=ENVS.get(group))
        if not ok:
            logger.critical("faied import directory {0}: {1}".format(iname, err))
    logger.info("finish import teleport {0}".format(tmpdir))

def updateTeleport(tmpdir, users, revision_version=""):
    logger.info("start checkout direct perl scripts")
    if len(revision_version) > 0:
        revision_version = "-r {0}".format(revision_version)
    ok, err = runMysqlShellCommand("/usr/bin/svn co {1} {0}".format(DIRECT_SVN, revision_version), tmpdir)
    if not ok:
        logger.critical("failed checkout direct perl scripts")
        raise ValueError(err)
    logger.info("success checkout direct perl scripts")
    if len(users) == 0:
        logger.info("start checkout users list")
        ok, err = runMysqlShellCommand("/usr/bin/svn co {1} {0}".format(USERS_SVN, revision_version), tmpdir)
        if not ok:
            logger.critical("failed checkout users list: {0}".format(err))
            raise ValueError(err)
    else:
        users_file = os.path.join(tmpdir, USERS_FILE)
        users_dir = os.path.dirname(users_file)
        if not os.path.exists(users_dir):
            os.mkdir(users_dir)
        logger.info("start wrtie users into file {0}".format(users_file))
        with open(users_file, 'w') as fd:
            fd.write('\n'.join(users))
    logger.info("success checkout users list")
    logger.info("start checkout dbschema")
    ok, err = runMysqlShellCommand("/usr/bin/svn co {1} {0}".format(SCHEMA_SVN, revision_version), tmpdir)
    if not ok:
        logger.critical("failed checkout dbschema")
        raise ValueError(err)
    logger.info("success checkout dbschema")
    logger.info("start checkout layout")
    ok, err = runMysqlShellCommand("/usr/bin/svn co {1} {0}".format(LAYOUT_SVN, revision_version), tmpdir)
    if not ok:
        logger.critical("failed checkout layout")
        raise ValueError(err)
    logger.info("success checkout layout")
    logger.info("start checkout settings")
    ok, err = runMysqlShellCommand("/usr/bin/svn co {1} {0}".format(SETTINGS_SVN, revision_version), tmpdir)
    if not ok:
        logger.critical("failed checkout settings")
        raise ValueError(err)
    logger.info("success checkout settings")

if __name__ == '__main__':
    parser = argparse.ArgumentParser(usage=USAGE)
    parser.add_argument("-d", "--debug", action="store_true",
        dest='debug', help="включить debug режим")
    parser.add_argument("-g", "--group", action="store", default="",
        dest="group", help="имя группы машин для экспорта/импорта")
    parser.add_argument("-u", "--users", action="store", default="",
        dest="users", help="список пользователей для экспорта")
    parser.add_argument("command", nargs='?', type=str, action='store', default="",
        help="команда export/import")
    parser.add_argument("-p", "--archive-path", action="store", default="",
        dest="apath", help="путь до импортированного архива")
    parser.add_argument("-r", "--revision-version", action="store", default="",
        dest="rver", help="версия ветки svn(по умолчанию последняя)")

    opts = parser.parse_args()

    #если указаны пользователи для импорта, то не делаем checkout списка из аркадии
    import_users = [] if len(opts.users) == 0 else [ i for i in opts.users.split(',') ]

    log_level = "DEBUG" if opts.debug else "INFO"
    logger, logch = startLogging(level=log_level)

    group = opts.group.lower()
    if not ENVS.has_key(group):
        err = "указанная группа {0} не найдена в {1}".format(group, ENVS)
        logger.critical(err)
        sys.exit(2)

    if opts.command.startswith("export"):
        runExport(import_users, opts.apath, opts.rver)
    elif opts.command.startswith("import"):
        print 'OK'
        runImport(opts.apath)
    else:
        logger.critical("неподдерживаемая команда. Выберите: export или import")
