import collections
import yaml


# add blank lines between top-level objects
class FeatureDumper(yaml.SafeDumper):

    def write_line_break(self, data=None):
        super(FeatureDumper, self).write_line_break(data)

        if len(self.indents) == 1:
            super(FeatureDumper, self).write_line_break()


class FeatureLoader(yaml.SafeLoader):
    pass


# support OrderedDict
def dict_representer(dumper, data):
    return dumper.represent_dict(data.iteritems())


def dict_constructor(loader, node):
    return collections.OrderedDict(loader.construct_pairs(node))


# force double quotes
class quoted(str):
    pass


def quoted_representer(dumper, data):
    return dumper.represent_scalar('tag:yaml.org,2002:str', data, style='"')


_mapping_tag = yaml.resolver.BaseResolver.DEFAULT_MAPPING_TAG

yaml.add_representer(collections.OrderedDict, dict_representer, Dumper=FeatureDumper)
yaml.add_constructor(_mapping_tag, dict_constructor, Loader=FeatureLoader)

yaml.add_representer(quoted, quoted_representer, Dumper=FeatureDumper)
