#!/usr/bin/env bash

SCRIPTS_PREFIX="/usr/local/bin"

LOCK_FILE=/var/frontend_environment.lock
BASHRC_SKEL=/etc/skel/.bashrc

UPDATE_TWILIGHT_SECRETS_PATH=$SCRIPTS_PREFIX/update-twilight-secrets


UPDATE_TWILIGHT_SECRETS=$(cat <<EOF
#!/usr/bin/env bash

if [ \$(id -u) -ne 0 ]; then
    echo 'нужны root-права'
    echo 'запустите sudo update-twilight-secrets'
    exit 1
fi

TWILIGHT_SECRET='sec-01e7f91ehb25rw8rpgq2ge1je9'

SECRET=\$(ya vault get version \$TWILIGHT_SECRET -o)

mkdir -p /etc/direct-tokens/twilight

node -e "console.log(Buffer.from(\$SECRET.env, 'base64').toString('utf8'))" > /etc/direct-tokens/twilight/.env

git config --global filter.lfs.process "git-lfs filter-process --skip"
git config --global filter.lfs.smudge "git-lfs smudge --skip %f"
git config --global filter.lfs.clean "git-lfs clean %f"
git config --global lfs.https://github.yandex-team.ru/.locksverify false

if [ -f $LOCK_FILE ]; then

    rm $LOCK_FILE

    echo '****************************************************************'
    echo '*                                                              *'
    echo '* Фронтовое окружение успешно настроено                        *'
    echo '*      а именно:                                               *'
    echo '*          - установлены секреты twilight-secrets              *'
    echo '*          - сконфигурирован git-lfs                           *'
    echo '*          - ...                                               *'
    echo '*          - PROFIT!                                           *'
    echo '*                                                              *'
    echo '* Инструкция по разворачиванию виртуалки и доступным командам: *'
    echo '*             https://nda.ya.ru/t/veZGHmZ83W9Z5Y               *'
    echo '*                                                              *'
    echo '****************************************************************'
fi

EOF
)

BASHRC_APPENDIX=$(cat <<EOF

if [ -f $LOCK_FILE ]; then
    echo '****************************************************************'
    echo '*                                                              *'
    echo '*                      !!!ВНИМАНИЕ!!!                          *'
    echo '*                                                              *'
    echo '* рекомендуем произвести настройку рабочего окружения          *'
    echo '*                     ------------------                       *'
    echo '*                                                              *'
    echo '* $ sudo update-twilight-secrets                               *'
    echo '*                                                              *'
    echo '*                     ------------------                       *'
    echo '*                                                              *'
    echo '* Инструкция по разворачиванию виртуалки и доступным командам: *'
    echo '*             https://nda.ya.ru/t/veZGHmZ83W9Z5Y               *'
    echo '*                                                              *'
    echo '****************************************************************'
fi

EOF
)

echo "${BASHRC_APPENDIX}" >> $BASHRC_SKEL

echo "${UPDATE_TWILIGHT_SECRETS}" > $UPDATE_TWILIGHT_SECRETS_PATH
chmod a+x $UPDATE_TWILIGHT_SECRETS_PATH

touch /var/frontend_environment.lock
