package main

import (
	"context"
	"fmt"
	"github.com/siddontang/go-mysql/client"
	"github.com/siddontang/go-mysql/mysql"
	r "github.com/siddontang/go-mysql/replication"
	"log"
	"time"
)

var (
	myGTID = "074c5e67-38cc-11eb-9836-a78bc0216598:1-9954215,1b7e497b-5666-65d3-07a2-a3e6b1bda0df:1-538698787," +
		"3b72f0cd-af83-e14a-de5d-9d360a7c5b51:1-206137309,4b1a6ae8-786b-2866-e0fd-eea6ecc170ff:1-6382707155," +
		"5c5e0b30-74a6-11e7-b862-2faedd4bde78:1-975799805,818a286b-55b9-c99f-0fb1-41d9f537d6a9:1-3429658598," +
		"9a0a4a7b-f42a-11e9-9762-9d3016e02208:1-1819108604,b6f6b628-188b-0c87-8d36-1b60a97f1bd5:1-726138487," +
		"bde1803b-65dc-3c84-2922-0497a05fed26:1-16,c4b9a86b-33e3-78c0-06c4-10d4c003597f:1-745119855," +
		"c5355abc-ab33-200e-b12e-420e9c69c726:1-740308921,d12a9499-38cb-11eb-bbe4-2a8b3b84e6f5:1-19631050"
)

func main() {
	cfg := r.BinlogSyncerConfig{
		ServerID: 6767,
		Flavor:   "mysql",
		Host:     "vla-t8t5hp9jxvq89pcy.db.yandex.net",
		Port:     3306,
		User:     "direct-test",
		Password: "37FPjgDC3mygBCRnZmGf",
	}

	conn, _ := client.Connect("vla-t8t5hp9jxvq89pcy.db.yandex.net:3306", "direct-test", "37FPjgDC3mygBCRnZmGf", "mysql")
	defer conn.Close()
	if err := conn.Ping(); err == nil {
		resp, err := conn.Execute("SHOW VARIABLES LIKE '%gtid_purged%'")
		if err != nil {
			log.Fatal(err)
		}
		if purgedGTID, err := resp.GetStringByName(0, "Value"); err == nil {
			myGTID = purgedGTID
		} else {
			log.Fatal(err)
		}
	}
	syncer := r.NewBinlogSyncer(cfg)
	defer syncer.Close()

	gtid, err := mysql.ParseGTIDSet(mysql.MySQLFlavor, myGTID)
	if err != nil {
		fmt.Printf("error parse gtid")
	}
	streamer, err := syncer.StartSyncGTID(gtid)
	if err != nil {
		fmt.Printf("%+v", err)
	}
	cntx, cancel := context.WithTimeout(context.Background(), 30*time.Second)
	defer cancel()
	for range [10]int{} {
		binevent, err := streamer.GetEvent(cntx)
		headerTime := (*binevent.Header).Timestamp
		if headerTime == 0 {
			continue
		} else {
			mytime := time.Unix(int64(headerTime), 0)
			fmt.Printf("%+v %s\n", mytime, err)
			break
		}
	}

	fmt.Println(cntx.Done())
}
