#!/bin/bash -e
sleep 1


if [ $(cat /etc/yandex/environment.type) == "production" ]; then
	export ZKPATH="/direct/db-config.json"
	export ENV="production"
	export ZKSERVERS="ppc-zk-1.da.yandex.ru:2181,ppc-zk-2.da.yandex.ru:2181,ppc-zk-1.da.yandex.ru:2181"
	export ZKTOKEN="/etc/direct-tokens/zookeeper_direct-prod-rw"
	export YTLOCKPATH="//home/direct/apps/mysql-binlog-age-check/lock"
	export YTLOCKTOKEN="/etc/direct-tokens/yt_robot-direct-yt"
	export YTLOCKCLUSTER="locke,seneca-sas"

	ulimit -v $((100*1024*1024))
	exec chpst -u ppc /usr/local/bin/mysql-binlog-age-check -zkServers $ZKSERVERS -zkPath $ZKPATH -env $ENV -syslog -ytLockPath $YTLOCKPATH -zkToken $ZKTOKEN -ytLockCluster $YTLOCKCLUSTER -ytLockToken $YTLOCKTOKEN >/dev/null 2>&1
else
	export ZKPATH="/direct/np/db-config/db-config.test.json"
        export ENV="testing"
	export ZKSERVERS="ppc-zk-1.da.yandex.ru:2181,ppc-zk-2.da.yandex.ru:2181,ppc-zk-1.da.yandex.ru:2181"
	export YTLOCKPATH="//home/direct-np/apps/mysql-binlog-age-check/lock"
        export YTLOCKTOKEN="/etc/direct-tokens/yt_robot-direct-yt-test"
	export YTLOCKCLUSTER="locke,seneca-sas"

	ulimit -v $((100*1024*1024))
        exec chpst -u ppc /usr/local/bin/mysql-binlog-age-check -zkServers $ZKSERVERS -zkPath $ZKPATH -env $ENV -syslog -ytLockPath $YTLOCKPATH -ytLockCluster $YTLOCKCLUSTER -ytLockToken $YTLOCKTOKEN >/dev/null 2>&1
fi	
