#!/bin/bash
#Скрипт для запуска threaddump в цикле для deploy.

ZKSERVERS=""
ZKPATH=""
ENV="dev"

case $1 in
	testing)
		ZKSERVERS="ppc-zk-1.da.yandex.ru:2181,ppc-zk-2.da.yandex.ru:2181,ppc-zk-3.da.yandex.ru:2181"
		ZKPATH="/direct/np/db-config/db-config.test.json"
		ENV="testing"
		INSTANCES="ppcdata1,ppcdata2,ppcdata3,ppcdata4,ppcdata5,ppcdata6,ppcdata7,ppcdata8,ppcdata9,ppcdata10,ppcdata11,ppcdata12,ppcdata13,ppcdata14,ppcdata15,ppcdata16,ppcdata17,ppcdata18,ppcdata19,ppcdata20,ppcdata21,ppcdata22,ppcdata23,ppcdata24,ppcdata25,ppcdata26,ppcdict,ppcmonitor"
                /usr/local/bin/mysql-master-monitor -zkservers $ZKSERVERS -zkpath $ZKPATH -env $ENV -instances $INSTANCES | /usr/local/bin/uaclient --logger_name MYSQL_MASTER_MONITOR.log --uri localhost:16400
        ;;
        devtest)
                ZKSERVERS="ppc-zk-1.da.yandex.ru:2181,ppc-zk-2.da.yandex.ru:2181,ppc-zk-3.da.yandex.ru:2181"
                ZKPATH="/direct/np/db-config/db-config.devtest.json"
                ENV="devtest"
                INSTANCES="ppcdata1,ppcdata2,ppcdata3,ppcdata4,ppcdata5,ppcdata6,ppcdata7,ppcdata8,ppcdata9,ppcdata10,ppcdata11,ppcdata12,ppcdata13,ppcdata14,ppcdata15,ppcdata16,ppcdata17,ppcdata18,ppcdata19,ppcdata20,ppcdata21,ppcdict,ppcmonitor"
                /usr/local/bin/mysql-master-monitor -zkservers $ZKSERVERS -zkpath $ZKPATH -env $ENV -instances $INSTANCES | /usr/local/bin/uaclient --logger_name MYSQL_MASTER_MONITOR.log --uri localhost:16400
        ;;
        dev7)
                ZKSERVERS="ppc-zk-1.da.yandex.ru:2181,ppc-zk-2.da.yandex.ru:2181,ppc-zk-3.da.yandex.ru:2181"
                ZKPATH="/direct/np/db-config/db-config.dev7.json"
                ENV="dev7"
		INSTANCES="ppcdata1,ppcmonitor"
		/usr/local/bin/mysql-master-monitor -zkservers $ZKSERVERS -zkpath $ZKPATH -env $ENV -instances $INSTANCES | /usr/local/bin/uaclient --logger_name MYSQL_MASTER_MONITOR.log --uri localhost:16400
	;;
	production)
		ZKSERVERS="ppc-zk-1.da.yandex.ru:2181,ppc-zk-2.da.yandex.ru:2181,ppc-zk-3.da.yandex.ru:2181"
		ZKPATH="/direct/db-config.json"
		ENV="production"
		INSTANCES="ppcmonitor,ppcdata1,ppcdata2,ppcdata3,ppcdata4,ppcdata5,ppcdata6,ppcdata7,ppcdata8,ppcdata9,ppcdata10,ppcdata11,ppcdata12,ppcdata13,ppcdata14,ppcdata15,ppcdata16,ppcdata17,ppcdata18,ppcdata19,ppcdata20,ppcdata21,ppcdata22,ppcdata23,ppcdata24,ppcdata25,ppcdata26,ppcdict,chassis"
		ZKTOKENFILE="/etc/direct-tokens/zookeeper_direct-prod-rw"
		/usr/local/bin/mysql-master-monitor -zkservers $ZKSERVERS -zkpath $ZKPATH -env $ENV -instances $INSTANCES -zktoken-file $ZKTOKENFILE | /usr/local/bin/uaclient --logger_name MYSQL_MASTER_MONITOR.log --uri localhost:16400
	;;

esac



exit 0

