package main

import (
	"context"
	"fmt"
	"os"

	"a.yandex-team.ru/library/go/yandex/oauth"
)

func main() {
	if len(os.Args) != 3 {
		fmt.Fprintf(os.Stderr, "Usage: %s client_id client_secret\n", os.Args[0])
		os.Exit(1)
	}
	clientID := os.Args[1]
	clientSecret := os.Args[2]

	oauthToken, err := oauth.GetTokenBySSH(context.Background(), clientID, clientSecret)
	if err != nil {
		panic(err)
	}

	fmt.Println(oauthToken)
}
