package main

import (
	"gopkg.in/yaml.v2"
	"io/ioutil"
	"path/filepath"
)

type Config map[string]interface{}

func LoadingConfig(path string) (Config, error) {
	config := make(map[string]interface{})
	mypath, err := filepath.Abs(path)
	if err != nil {
		return nil, err
	}
	data, err := ioutil.ReadFile(mypath)
	if err != nil {
		return nil, err
	}

	err = yaml.Unmarshal(data, &config)
	if err != nil {
		return nil, err
	}

	return config, nil
}

func (c Config) Find(nameKey string, defaultValue interface{}) interface{} {
	if val, ok := c[nameKey]; ok {
		return val
	}
	return defaultValue
}
