package main

import (
	"flag"
	"fmt"
	"log"

	//"flag"
	//"strings"

	tm "a.yandex-team.ru/direct/infra/go-libs/pkg/transfer-manager"
)

const (
	DefaultFolderId      = "mdb-junk"
	DefaultProject       = "direct"
	DefaultTypeTransport = "SNAPSHOT_AND_INCREMENT"
)

var (
	tokenFile, folderID, description, instanceName string
	debugMode, listEndpoints, createMysqlEndpoint  bool
	createMysqlTransport                           bool

	databaseName, hostname, clusterID, user, typeEndpoint, typeDelivery, typeTransport string
	mysqlPort                                                                          int
	mysqlPassword                                                                      tm.Password

	srcEndpointID, dstEndpointID string
)

func main() {
	flag.StringVar(&tokenFile, "token", "/tmp/tm.token", "file with oauth token for TM")
	flag.BoolVar(&debugMode, "debug", false, "debug mode")
	flag.BoolVar(&listEndpoints, "list-endpoints", false, "listing endpoint")
	flag.BoolVar(&createMysqlEndpoint, "create-endpoint", false, "create endpoint")
	flag.BoolVar(&createMysqlTransport, "create-mysql-transport", false, "create mysql transport")
	flag.StringVar(&folderID, "folder-id", DefaultFolderId, "folder id for TM")
	flag.StringVar(&description, "description", DefaultProject, "description for filter listing")
	flag.StringVar(&instanceName, "instance", "", "mysql instance name for TM 'name'")
	flag.StringVar(&databaseName, "database", "", "database name")
	flag.StringVar(&hostname, "hostname", "", "hostname server")
	flag.StringVar(&clusterID, "mdb-cluster-id", "", "clusterid databse in mdb")
	flag.StringVar(&user, "user", "", "username for connectl")
	flag.StringVar(&typeEndpoint, "type-endpoint", "", "type endpoint: hardware/mdb")
	flag.IntVar(&mysqlPort, "port", 0, "port for connect")
	flag.StringVar(&typeDelivery, "type-delivery", "", "type delivery endpoint: source/target")
	flag.StringVar(&typeTransport, "type-transport", DefaultTypeTransport,
		"type transport: SNAPSHOT_AND_INCREMENT(default)")
	flag.Parse()

	if debugMode {
		tm.SetLogLevel(1)
	} else {
		tm.SetLogLevel(4)
	}

	conn, err := tm.NewConnection(tokenFile)
	if err != nil {
		log.Fatalf("%s", err)
	}

	switch {
	case listEndpoints:
		endpoints, err := tm.ListEndpointTM(conn, folderID)
		if err != nil {
			log.Fatal(err)
		}
		endpoints = endpoints.FilterByDescription(description)
		if len(instanceName) > 0 {
			endpoints = endpoints.FilterByName(instanceName)
		}
		for _, e := range endpoints.Endpoints {
			fmt.Printf("Name: %s, ID: %s, Direction: %s, Database: %s\n", e.Name, e.ID, e.Direction, e.Database())
		}
	case createMysqlEndpoint:
		hostCluster := hostname
		if typeEndpoint == "mdb" {
			hostCluster = clusterID
		}
		resp, err := tm.CreateMysqlEndpointTM(
			fmt.Sprintf("%s %s mysql instance %s", description, typeDelivery, instanceName),
			folderID,
			instanceName,
			databaseName,
			hostCluster, //hostname or clusterID
			user,
			mysqlPort,
			mysqlPassword,
			typeEndpoint,
			typeDelivery,
			conn,
		)
		if err != nil {
			log.Fatal(err)
		}
		fmt.Println(resp)
		//if resp.Done && resp.Code == 0 {}

	case createMysqlTransport:
		resp, err := tm.CreateMysqlTansportTM(
			fmt.Sprintf("%s mysql transport %s", description, instanceName),
			folderID,
			fmt.Sprintf("%s_%s", hostname, clusterID),
			srcEndpointID,
			dstEndpointID,
			typeTransport,
			conn,
		)
		if err != nil {
			log.Fatal(err)
		}
		fmt.Println(resp)

	}

	/*CreateMysqlEndpoint
	description содержит обязательный direct_ и возвращает ID
	target := tm.NewMysqlBlock("test_ppcdiscord", "mdb-junk", "ppcdiscord2", "ppc",
		"ppcdiscord.yandex.ru",
		"tmclient",
		3307,
		tm.Password{
			Secret: tm.Secret{
				"mysql_loaddb_user",
				"ver-01e971q19vswaewex55wy29v2f",
			},
		},
		"hardware", "source")
	out, err := target.PrepareRequest()
	fmt.Printf("%+v %s\n", out, err)
	w, _ := out.Marshal()
	fmt.Printf("%s %s\n", w)
	conn, err := tm.NewConnection(tokenFile)
	if err != nil {
		log.Fatalf("error connetct to TM: %s", err)
	}
	resp, err := tm.CreateEndpointTM(conn, w)
	log.Printf("%+v, \n err: %s", resp, err)
	*/

}
