package mdbgrpc

import (
	"context"
	"crypto/x509"
	"fmt"
	"google.golang.org/grpc"
	"google.golang.org/grpc/credentials"
	"google.golang.org/grpc/keepalive"
	"time"

	logger "a.yandex-team.ru/direct/infra/go-libs/pkg/logformat"
)

var (
	DefaultAddressAPI = "gw.db.yandex-team.ru:443"
)

//Функция для создания коннекта:
func NewDealer(address string, auth AIM) (*grpc.ClientConn, context.CancelFunc, error) {
	if len(address) == 0 {
		address = DefaultAddressAPI
	}
	cntx, cancel := context.WithCancel(context.Background())
	pool, _ := x509.SystemCertPool()
	tlsClient := credentials.NewClientTLSFromCert(pool, "")
	dialOptions := []grpc.DialOption{
		grpc.WithUserAgent("grpc-go/" + grpc.Version),
		grpc.WithKeepaliveParams(
			keepalive.ClientParameters{
				Time:    1 * time.Minute,  //время ожидания ответа
				Timeout: 20 * time.Second, //интервал отправки keepalive
			}),
		grpc.WithTransportCredentials(tlsClient),
	}

	if auth.Token != nil {
		c, err := auth.GetRequestMetadata(cntx)
		logger.Debug("auth.GetRequestMetadata %s, error: %s, %+v\n", c, err, auth.Token)
		dialOptions = append(dialOptions, grpc.WithPerRPCCredentials(auth))
	}
	conn, err := grpc.DialContext(cntx, fmt.Sprintf("dns:///%s", address), dialOptions...)
	return conn, cancel, err
}
