package mdbgrpc

import (
	"context"
	"fmt"
	"google.golang.org/grpc"
	"time"

	"a.yandex-team.ru/cloud/bitbucket/public-api/yandex/cloud/iam/v1"
)

type AimToken string

type AimTokenGenerator func() (iamTokenReq *iam.CreateIamTokenRequest, err error)

func (AimTokenGenerator) YandexCloudAPICredentials() {}

func (a AimTokenGenerator) IAMTokenRequest() (iamTokenReq *iam.CreateIamTokenRequest, err error) {
	return a()
}

type AIM struct {
	Token *iam.CreateIamTokenResponse
}

func NewAIM(token *iam.CreateIamTokenResponse) AIM {
	return AIM{token}
}

func (at AIM) GetRequestMetadata(ctx context.Context, uri ...string) (map[string]string, error) {
	if len(at.Token.IamToken) == 0 {
		return nil, fmt.Errorf("empty token")
	}
	return map[string]string{
		"authorization": "Bearer " + at.Token.IamToken,
	}, nil
}

func (at AIM) RequireTransportSecurity() bool {
	return len(at.Token.IamToken) > 0
}

//Создает генератор функцию для получения запроса iam токена
func NewIamTokenGenerator(key CloudKey) (Credentials, error) {
	return AimTokenGenerator(func() (*iam.CreateIamTokenRequest, error) {
		signedJWT, err := key.SignedJwtToken()
		if err != nil {
			return nil, fmt.Errorf("JWT sign failed: %s", err)
		}
		return &iam.CreateIamTokenRequest{
			Identity: &iam.CreateIamTokenRequest_Jwt{
				Jwt: signedJWT,
			},
		}, nil
	}), nil
}

func (a AimTokenGenerator) NewIamToken(conn *grpc.ClientConn) (*iam.CreateIamTokenResponse, error) {
	cntx, cancel := context.WithTimeout(context.Background(), 30*time.Second)
	defer cancel()
	aimreq, err := a.IAMTokenRequest()
	if err != nil {
		return nil, err
	}
	return iam.NewIamTokenServiceClient(conn).Create(cntx, aimreq)
}
