package mdbgrpc

import (
	"context"
	"fmt"
	"google.golang.org/grpc"
	"time"

	msql "a.yandex-team.ru/cloud/bitbucket/public-api/yandex/cloud/mdb/mysql/v1"
	mop "a.yandex-team.ru/cloud/bitbucket/public-api/yandex/cloud/operation"
	logger "a.yandex-team.ru/direct/infra/go-libs/pkg/logformat"
)

func SwitchMaster(conn *grpc.ClientConn, clusterID, newMaster string) (resp *mop.Operation, err error) {
	client := msql.NewClusterServiceClient(conn)
	if len(clusterID) == 0 {
		return nil, fmt.Errorf("empty cluster id")
	}
	req := msql.StartClusterFailoverRequest{
		ClusterId: clusterID,
		HostName:  newMaster,
	}
	cntx, cancel := context.WithTimeout(context.Background(), 30*time.Second)
	defer cancel()
	for range [3]int{} {
		resp, err = client.StartFailover(cntx, &req)
		if err != nil {
			logger.Crit("error SwitchMaster: %s", err)
			time.Sleep(5 * time.Second)
			continue
		}
		return resp, err
	}
	return nil, err
}

func StreamLogs(cntx context.Context, conn *grpc.ClientConn, clusterID string) (msql.ClusterService_StreamLogsClient, error) {
	client := msql.NewClusterServiceClient(conn)
	if len(clusterID) == 0 {
		return nil, fmt.Errorf("empty clusterID")
	}
	req := msql.StreamClusterLogsRequest{
		ClusterId:   clusterID,
		ServiceType: msql.StreamClusterLogsRequest_MYSQL_SLOW_QUERY,
	}
	return client.StreamLogs(cntx, &req)
}
