package mdbgrpc

import (
	"context"
	"google.golang.org/grpc"
	"time"

	mop "a.yandex-team.ru/cloud/bitbucket/public-api/yandex/cloud/operation"
	logger "a.yandex-team.ru/direct/infra/go-libs/pkg/logformat"
)

func GetOperationStatus(conn *grpc.ClientConn, opid *mop.Operation) (done bool, err error) {
	client := mop.NewOperationServiceClient(conn)
	req := mop.GetOperationRequest{
		OperationId: opid.GetId(),
	}
	cntx, cancel := context.WithTimeout(context.Background(), 30*time.Second)
	defer cancel()
	var resp *mop.Operation
	for range [3]int{} {
		resp, err = client.Get(cntx, &req)
		if err != nil {
			logger.Crit("error GetOperationStatus: %s", err)
			time.Sleep(5 * time.Second)
			continue
		}
		break
	}
	return resp.GetDone(), nil
}
