package sslmode

import (
	"crypto/tls"
	"crypto/x509"
	"fmt"
	"io/ioutil"
	"net/http"
)

const (
	CAInternal = "/usr/share/yandex-internal-root-ca/YandexInternalRootCA.crt"
)

var CACert *string

func SetCACert(cacert string) {
	*CACert = cacert
}

func init() {
	tmp := ""
	CACert = &tmp
}

type ErrorCertificate struct {
	msg string
}

func (e ErrorCertificate) Error() string {
	return e.msg
}

func NewErrorCertificate(msg string, args ...string) ErrorCertificate {
	return ErrorCertificate{
		msg: fmt.Sprintf(msg, args),
	}
}

func NewCertificatePool() (pool *x509.CertPool, err error) {
	if pool, err = x509.SystemCertPool(); err != nil || len(*CACert) == 0 {
		return
	}

	myca, err := ioutil.ReadFile(*CACert)
	if err != nil {
		return pool, NewErrorCertificate("error read file %s: %s", *CACert, err.Error())
	}
	pool.AppendCertsFromPEM(myca)
	return pool, nil
}

func NewCertificatePoolInternal() (pool *x509.CertPool, err error) {
	return NewCertificatePool()
}

func NewTLSConfig() (*tls.Config, error) {
	pool, err := NewCertificatePool()
	return &tls.Config{
		RootCAs: pool,
	}, err
}

func NewTLSConfigInternal() (*tls.Config, error) {
	pool, err := NewCertificatePoolInternal()
	return &tls.Config{
		RootCAs: pool,
	}, err
}

func NewHTTPSClient() (*http.Client, error) {
	tlsconfig, err := NewTLSConfigInternal()
	client := &http.Client{}
	client.Transport = &http.Transport{
		TLSClientConfig: tlsconfig,
	}
	return client, err
}
