package tmlib

import (
	"encoding/json"
	"fmt"
	"testing"
)

func TestMysqlBlockTest1(t *testing.T) {
	target := NewMysqlBlock(
		"ppcdiscord.yandex.ru source mysql instance ppcdata20",
		"mdb-junk",
		"ppcdata20_ppcdiscord.yandex.ru",
		"ppc",
		"43",
		"ppcdiscord.yandex.ru",
		"tmclient",
		"3307",
		Password{
			Secret: Secret{
				"mysql_loaddb_user",
				"ver-01e971q19vswaewex55wy29v2f",
			},
		},
		"hardware",
		"source",
	)
	out, err := target.PrepareRequest()
	if err != nil {
		t.Error(fmt.Errorf("error %s for %s", err, out))
	}

	result := []byte("{\"description\":\"ppcdiscord.yandex.ru source mysql instance ppcdata20\",\"folder_id\":\"mdb-junk\"," +
		" \"mysql_on_premise_source\":{\"database\":\"ppc\",\"slot_id\":\"43\"," +
		" \"host\":\"ppcdiscord.yandex.ru\",\"password\":{\"secret\":{\"key\":\"mysql_loaddb_user\"," +
		" \"version_id\":\"ver-01e971q19vswaewex55wy29v2f\"}},\"port\":3307,\"user\":\"tmclient\"}," +
		" \"name\":\"ppcdata20_ppcdiscord.yandex.ru\"}")
	var good MapStringInterface
	if err := json.Unmarshal(result, &good); err != nil {
		t.Error(err)
	}
	for key, val := range good {
		if oval, ok := out[key]; !ok {
			t.Errorf("not found key %s in %s", key, out)
		} else if fmt.Sprint(oval) != fmt.Sprint(val) {
			t.Errorf("wrong value for key %s: current %s(need %s)", key, oval, val)
		}
	}
}

func TestMysqlBlockTest2(t *testing.T) {
	target := NewMysqlBlock(
		"test_ppcdiscord",
		"mdb-junk",
		"ppcdiscord2",
		"ppc",
		"44",
		"ppcdiscord.yandex.ru",
		"tmclient",
		"3307",
		Password{
			Secret: Secret{
				"mysql_loaddb_user",
				"ver-01e971q19vswaewex55wy29v2f",
			},
		},
		"hardware",
		"target",
	)
	out, err := target.PrepareRequest()
	if err != nil {
		t.Error(err)
	}

	result := []byte("{\"description\":\"test_ppcdiscord\",\"folder_id\":\"mdb-junk\",\"mysql_on_premise_target\":{\"database\":\"ppc\"," +
		" \"host\":\"ppcdiscord.yandex.ru\",\"slot_id\":\"44\",\"password\":{\"secret\":{\"key\":\"mysql_loaddb_user\"," +
		" \"version_id\":\"ver-01e971q19vswaewex55wy29v2f\"}},\"port\":3307,\"user\":\"tmclient\"},\"name\":\"ppcdiscord2\"}")
	var good MapStringInterface
	if err := json.Unmarshal(result, &good); err != nil {
		t.Error(err)
	}
	for key, val := range good {
		if oval, ok := out[key]; !ok {
			t.Errorf("not found key %s in %s", key, out)
		} else if fmt.Sprint(oval) != fmt.Sprint(val) {
			t.Errorf("wrong value for key %s: current %s(need %s)", key, oval, val)
		}
	}
}

/*
func TestMysqlBlockTest3(t *testing.T) {
	target := CreateMysqlEndpointTM(
		"mdb-junk",
		"ppcdata20",
		"ppc",
		"ppcdiscord.yandex.ru",
		"tmclient",
		3307,
		Password{
			Secret: Secret{
				"mysql_loaddb_user",
				"ver-01e971q19vswaewex55wy29v2f",
			},
		},
		"hardware",
		"source",

	)
	out, err := target.PrepareRequest()
	if err != nil {
		t.Error(fmt.Errorf("error %s for %s", err, out))
	}

	result := []byte("{\"description\":\"ppcdiscord.yandex.ru source mysql instance ppcdata20\",\"folder_id\":\"mdb-junk\"," +
		" \"mysql_onpremise_source\":{\"database\":\"ppc\"," +
		" \"host\":\"ppcdiscord.yandex.ru\",\"password\":{\"secret\":{\"key\":\"mysql_loaddb_user\"," +
		" \"version_id\":\"ver-01e971q19vswaewex55wy29v2f\"}},\"port\":3307,\"user\":\"tmclient\"}," +
		" \"name\":\"ppcdata20_ppcdiscord.yandex.ru\"}")
	var good MapStringInterface
	if err := json.Unmarshal(result, &good); err != nil {
		t.Error(err)
	}
	for key, val := range good {
		if oval, ok := out[key]; !ok {
			t.Errorf("not found key %s in %s", key, out)
		} else if fmt.Sprint(oval) != fmt.Sprint(val) {
			t.Errorf("wrong value for key %s: current %s(need %s)", key, oval, val)
		}
	}

Endpoint Created true <nil> dteo3snn9buols5bgqq2 { } 2020-06-05T11:41:59Z map[@type:type.googleapis.com/yandex.cloud.priv.datatransfer.v1.Endpoint author:fools3906s1f9aoc8i02 description:direct_source_mysql_instance_ppcdata20 direction:SOURCE folder_id:mdb-junk id:dteo3snn9buols5bgqq2 mysql_onpremise_source:map[database:ppc host:ppcdiscord.yandex.ru user:tmclient] name:ppcdata20_ppcdiscord.yandex.ru_endpoint type:MYSQL] 0 <nil> }
}*/
