package tmlib

type Secret struct {
	Key       string `json:"key"`
	VersionID string `json:"version_id"`
}

type Password struct {
	//Raw string `json:"raw"`
	Secret `json:"secret"`
}

type MysqlOnpremiseTarget struct {
	Database             string `json:"database"`
	Host                 string `json:"host"`
	Port                 string `json:"port"`
	Password             `json:"password"`
	User                 string `json:"user"`
	SlotID               string `json:"slot_id"`
	SkipConstraintChecks bool   `json:"skip_constraint_checks"`
}

type MysqlOnpremiseSource struct {
	Database string `json:"database"`
	Host     string `json:"host"`
	Port     string `json:"port"`
	Password `json:"password"`
	User     string `json:"user"`
	SlotID   string `json:"slot_id"`
}

type MysqlTarget struct {
	Database             string `json:"database"`
	Host                 string `json:"cluster_id"`
	Port                 string `json:"port"`
	Password             `json:"password"`
	User                 string `json:"user"`
	SlotID               string `json:"slot_id"`
	SkipConstraintChecks bool   `json:"skip_constraint_checks"`
}

type MysqlSource struct {
	Database string `json:"database"`
	Host     string `json:"cluster_id"`
	Port     string `json:"port"`
	Password `json:"password"`
	User     string `json:"user"`
	SlotID   string `json:"slot_id"`
}

type Endpoints struct {
	Endpoints []Endpoint `json:"endpoints"`
}

type Endpoint struct {
	Author               string `json:"author"`
	Type                 string `json:"type"`
	Direction            string `json:"direction"`
	Description          string `json:"description"`
	FolderID             string `json:"folder_id"`
	ID                   string `json:"id"`
	Name                 string `json:"name"`
	MysqlOnpremiseTarget `json:"on_premise_mysql_target"`
	MysqlOnpremiseSource `json:"on_premise_mysql_source"`
	MysqlTarget          `json:"managed_mysql_target"`
	MysqlSource          `json:"managed_mysql_source"`
}

type EndpointID struct {
	EndpointID string `json:"endpoint_id"`
}

type MapStringInterface map[string]interface{}

type MetaData struct {
	TypeURL string `json:"type_url"`
	Value   string `json:"value"`
}

type ResponseTarget struct {
	CreatedAT   string      `json:"created_at"`
	CreatedBY   string      `json:"created_by"`
	Description string      `json:"description"`
	Done        bool        `json:"done"`
	Error       interface{} `json:"error"`
	ID          string      `json:"id"`
	MetaData    `json:"metadata"`
	ModifiedAT  string      `json:"modified_at"`
	Response    interface{} `json:"response"`
	Code        int         `json:"code"`
	Details     interface{} `json:"details"`
	Message     string      `json:"message"`
}

//Blocks
type MysqlBlock struct {
	Description string      `json:"description"`
	FolderID    string      `json:"folder_id"`
	Name        string      `json:"name"`
	Target      interface{} `json:"-"`
}

type MysqlOnpremiseSourceBlock struct {
	MysqlOnpremiseSource `json:"on_premise_mysql_source"`
}

type MysqlOnpremiseTargetBlock struct {
	MysqlOnpremiseTarget `json:"on_premise_mysql_target"`
}

type MysqlSourceBlock struct {
	MysqlSource `json:"managed_mysql_source"`
}

type MysqlTargetBlock struct {
	MysqlTarget `json:"managed_mysql_target"`
}

type TransferBlock struct {
	Description string `json:"description"`
	FolderID    string `json:"folder_id"`
	Name        string `json:"name"`
	SourceID    string `json:"source_id"`
	TargetID    string `json:"target_id"`
	Type        string `json:"type"`
}

type OperationStatus struct {
	Done            bool   `json:"done"`
	Message         string `json:"message"`
	OperationIDCode int    `json:"-"`
}

type OperationIDStatus struct {
	OperationIDStatus string `json:"operation_id_status"`
}

type TransferID struct {
	TransferID string `json:"transfer_id"`
}

type TransfersStatus struct {
	Transfers []TransferStatus `json:"transfers"`
}

type TransferStatus struct {
	ID          string `json:"id"`
	FolderID    string `json:"folder_id"`
	Name        string `json:"name"`
	Description string `json:"description"`
	SourceTM    `json:"source"`
	TargetTM    `json:"target"`
	Status      string      `json:"status"`
	Dashboard   interface{} `json:"dashboard"`
	Error       string      `json:"error"`
	Message     string      `json:"message"`
	Warning     string      `json:"warning"`
}

type TransferOperationsStatus struct {
	Operations []ResponseTarget
}

type SourceTM struct {
	ID                   string `json:"id"`
	FolderID             string `json:"folder_id"`
	Name                 string `json:"name"`
	Direction            string `json:"direction"`
	Type                 string `json:"type"`
	MysqlSource          `json:"managed_mysql_source"`
	MysqlOnpremiseSource `json:"on_premise_mysql_source"`
}

type TargetTM struct {
	ID                   string `json:"id"`
	FolderID             string `json:"folder_id"`
	Name                 string `json:"name"`
	Direction            string `json:"direction"`
	Type                 string `json:"type"`
	MysqlTarget          `json:"managed_mysql_target"`
	MysqlOnpremiseTarget `json:"on_premise_mysql_target"`
}

type OperationTM struct {
	Operation  string `json:"operation"`
	TransferID string `json:"transfer_id"`
}
