#!/bin/bash

set -e

TMP=`mktemp -d`

echo "checkout flamegraph..."
git clone git@github.com:brendangregg/FlameGraph.git $TMP/flamegraph

echo "upload to Sandbox..."
ya upload --tar --do-not-remove --json-output $TMP/flamegraph >$TMP/upload_result.json

echo "Get resource id..."
RESOURCE_ID=$(jq -s .[0].resource_id <$TMP/upload_result.json)
echo $RESOURCE_ID

echo "Done."


