import json
import random

DEFAULT_CONFIG = '/etc/yandex-direct/db-config.json'


class DbConfig(object):
    def __init__(self, config_file=DEFAULT_CONFIG):
        self.config_file = config_file

    def get_db_config(self, dbname):
        """
        По имени базы получить dict с конфигом
        В имени может встретиться компонента ? - это означает любой child с ненулевым(или неопределённым) весом
        """

        cur_cfg = self.parse_db_config()
        ret = cur_cfg.copy()
        for part in dbname.split(":"):
            childs = cur_cfg.get('CHILDS', None)
            if childs is not None and part == '?' and childs:
                cur_cfg = next(
                    iter(sorted(childs.values(), key=lambda v: v.get('weight', 1) * random.random(), reverse=True)))
                ret.update(cur_cfg)
            elif childs is not None and part in childs:
                cur_cfg = childs[part]
                ret.update(cur_cfg)
            else:
                raise Exception("Can't find db config for %s" % dbname)

        if 'CHILDS' in cur_cfg:
            if '_' in cur_cfg['CHILDS']:
                ret.update(cur_cfg['CHILDS']['_'])
            else:
                raise Exception("Can't find db config for %s (not leaf)" % dbname)

        if 'CHILDS' in ret:
            del ret['CHILDS']

        ret['dbname'] = dbname
        if 'db' not in ret:
            ret['db'] = dbname.split(':')[0]

        if 'pass' in ret and isinstance(ret['pass'], dict):
            if 'file' in ret['pass']:
                ret['pass'] = open(ret['pass']['file'], 'r').read().strip()
            else:
                raise Exception('incorrect pass in ' + dbname + ': dict, but without file')

        return ret

    def parse_db_config(self):
        """
        Прочитать и распарсить конфиг коннектов к БД
        """
        return json.loads(open(self.config_file).read())['db_config']
