package ru.yandex.market.clickhouse.dealer.clickhouse;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 16/06/2018
 */
public class ClickHousePartitionParser {
    private ClickHousePartitionParser() {
    }

    public static ClickHousePartitionExtractor parsePartitionSystem(String partitionBy, String ytPartitionNameColumn) {

        if (partitionBy.equals(SingletonClickHousePartitionExtractor.SINGLETON_PARTITION_BY)) {
            return SingletonClickHousePartitionExtractor.INSTANCE;
        }
        Preconditions.checkState(
            !Strings.isNullOrEmpty(ytPartitionNameColumn),
            "ytPartitionNameColumn is empty, but not 'tuple()' selected. This is not supported: %s",
            partitionBy
        );

        if (partitionBy.equals("toYYYYMM(" + ytPartitionNameColumn + ")")) {
            return ToYyyyMmClickHousePartitionExtractor.INSTANCE;
        } else if (partitionBy.equals("toMonday(" + ytPartitionNameColumn + ")")) {
            return ToMondayHousePartitionExtractor.INSTANCE;
        } else if (partitionBy.equals(ytPartitionNameColumn)) {
            return date -> String.format("'%s'", date);
        }
        throw new IllegalStateException(
            "Unsupported partitionBy mode '" + partitionBy +
                "' with ytPartitionNameColumn '" + ytPartitionNameColumn + "'"
        );
    }
}
