package ru.yandex.market.clickhouse.dealer.clickhouse;

import java.time.LocalDate;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 16/06/2018
 */
public class ToMondayHousePartitionExtractor implements ClickHousePartitionExtractor {

    public static final ToMondayHousePartitionExtractor INSTANCE = new ToMondayHousePartitionExtractor();

    private ToMondayHousePartitionExtractor() {
    }

    @Override
    public String extract(String ytPartition) {
        LocalDate date = LocalDate.parse(ytPartition);
        LocalDate monday = date.minusDays(date.getDayOfWeek().getValue() - 1);
        return "'" + monday.toString() + "'";
    }
}
