package ru.yandex.market.clickhouse.dealer.config;

import java.util.Objects;

/**
 * @author Aleksei Malygin <a href="mailto:Malygin-Me@yandex-team.ru"></a>
 * Date: 2019-01-18
 */
public class DealerClusterConfig {

    private final String clusterId;
    private final String clusterForDdlApply;

    private DealerClusterConfig(Builder builder) {
        clusterId = builder.clusterId;
        clusterForDdlApply = builder.clusterForDdlApply;
    }

    public String getClusterId() {
        return clusterId;
    }

    public String getClusterForDdlApply() {
        return clusterForDdlApply;
    }

    public static DealerClusterConfig.Builder newBuilder() {
        return new DealerClusterConfig.Builder();
    }

    public static final class Builder {

        private String clusterId;
        private String clusterForDdlApply;

        public Builder withClusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public Builder withClusterForDdlApply(String clusterForDdlApply) {
            this.clusterForDdlApply = clusterForDdlApply;
            return this;
        }

        public DealerClusterConfig build() {
            return new DealerClusterConfig(this);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DealerClusterConfig that = (DealerClusterConfig) o;
        return Objects.equals(clusterId, that.clusterId) &&
            Objects.equals(clusterForDdlApply, that.clusterForDdlApply);
    }

    @Override
    public int hashCode() {
        return Objects.hash(clusterId, clusterForDdlApply);
    }
}
