package ru.yandex.market.clickhouse.dealer.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.springframework.util.StringValueResolver;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author Aleksei Malygin <a href="mailto:Malygin-Me@yandex-team.ru"></a>
 * Date: 2019-01-18
 */
public class DealerClusterConfigParser extends DealerCommonConfigParser<Collection<DealerClusterConfig>> {

    public DealerClusterConfigParser(StringValueResolver resolver) {
        super(resolver);
    }

    @Override
    public Collection<DealerClusterConfig> parseConfig(JsonObject configObject, String name) {
        Set<Map.Entry<String, JsonElement>> clusterObjects = configObject.entrySet();
        return clusterObjects.stream()
            .map(
                c -> DealerClusterConfig.newBuilder()
                    .withClusterId(c.getKey())
                    .withClusterForDdlApply(
                        getResolvedString(
                            c.getValue().getAsJsonObject(),
                            "clusterForDdlApply"
                        )
                    )
                    .build()
            )
            .collect(Collectors.toList());
    }
}
