package ru.yandex.market.clickhouse.dealer.operation;

import ru.yandex.market.clickhouse.dealer.config.DealerGlobalConfig;
import ru.yandex.market.clickhouse.dealer.state.PartitionState;
import ru.yandex.market.clickhouse.dealer.tm.TmTaskState;

import java.util.Collections;
import java.util.List;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 04/06/2018
 */
public interface OperationContext {

    void applyDdl();

    void clearTempTable() throws InterruptedException;

    void saveState();

    /**
     * @param ytPartition
     * @return tmTaskId
     */
    String startTmCopyOperation(String ytPartition);

    void retryTmCopyOperation(String tmTaskId);

    TmTaskState pollTmTask(String tmTaskId) throws InterruptedException;

    long countTempTableRows();

    long countTargetTableRows(String clickHousePartition);

    void replacePartitionFromTempTable(String clickHousePartition) throws InterruptedException;

    void replacePartitionFromTargetTable(String clickHousePartition) throws InterruptedException;

    void updatePartitionStates(List<PartitionState> partitionStates);

    default void updatePartitionState(PartitionState state) {
        updatePartitionStates(Collections.singletonList(state));
    }

    void cleanError();

    DealerGlobalConfig getGlobalConfig();
}
