package ru.yandex.market.clickhouse.dealer.state;

import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;
import ru.yandex.market.clickhouse.dealer.config.DealerConfig;

import java.time.Instant;

/**
 * @author Aleksei Malygin <a href="mailto:Malygin-Me@yandex-team.ru"></a>
 * Date: 24.07.2018
 */

@Document(collection = "mismatches")
public class DataMismatch {
    public static final String VALIDATION_TIME_FIELD = "validationTime";
    public static final String ACKNOWLEDGE_FIELD = "acknowledged";

    private final DealerConfig.Key configKey;
    private final String clickHousePartition;
    private final String ytPartition;
    private final Long rowCountInClickHouse;
    private final Long rowCountInDealerState;
    @Indexed
    @Field(VALIDATION_TIME_FIELD)
    private final Instant validationTime;
    /* required to calm down dataMismatch monitoring */
    @Field(ACKNOWLEDGE_FIELD)
    private final boolean acknowledged;

    private DataMismatch(Builder builder) {
        this.configKey = builder.configKey;
        this.clickHousePartition = builder.clickHousePartition;
        this.ytPartition = builder.ytPartition;
        this.rowCountInClickHouse = builder.rowCountInClickHouse;
        this.rowCountInDealerState = builder.rowCountInDealerState;
        this.validationTime = builder.validationTime;
        this.acknowledged = false;
    }

    public static DataMismatch.Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private DealerConfig.Key configKey;
        private String clickHousePartition;
        private String ytPartition;
        private Long rowCountInClickHouse;
        private Long rowCountInDealerState;
        private Instant validationTime;

        public Builder withConfig(DealerConfig.Key configKey) {
            this.configKey = configKey;
            return this;
        }

        public Builder withChPartition(String clickHousePartition) {
            this.clickHousePartition = clickHousePartition;
            return this;
        }

        public Builder withYtPartition(String ytPartition) {
            this.ytPartition = ytPartition;
            return this;
        }

        public Builder withClickHouseRowCount(Long rowCountInClickHouse) {
            this.rowCountInClickHouse = rowCountInClickHouse;
            return this;
        }

        public Builder withDealerStateRowCount(Long rowCountInDealerState) {
            this.rowCountInDealerState = rowCountInDealerState;
            return this;
        }

        public Builder withValidationTime(Instant validationTime) {
            this.validationTime = validationTime;
            return this;
        }

        public DataMismatch build() {
            return new DataMismatch(this);
        }
    }

    @Override
    public String toString() {
        return "DataMismatch{" +
            "configKey=" + configKey +
            ", clickHousePartition='" + clickHousePartition + '\'' +
            ", ytPartition='" + ytPartition + '\'' +
            ", rowCountInClickHouse=" + rowCountInClickHouse +
            ", rowCountInDealerState=" + rowCountInDealerState +
            ", validationTime=" + validationTime +
            '}';
    }
}
