package ru.yandex.market.clickhouse.dealer.state;

import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import ru.yandex.market.clickhouse.dealer.config.DealerConfig;

import java.time.Instant;
import java.util.Optional;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 09/04/2018
 */
public class DealerDao {
    private final MongoTemplate mongoTemplate;

    public DealerDao(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    public Optional<DealerState> loadState(DealerConfig.Key key) {
        return Optional.ofNullable(mongoTemplate.findById(key, DealerState.class));
    }

    public <T> void save(T state) {
        mongoTemplate.save(state);
    }

    public <T> void insert(T state) {
        mongoTemplate.insert(state);
    }

    public long getDataMismatchCount(Instant since) {
        Query query = Query.query(
            Criteria
                .where(DataMismatch.VALIDATION_TIME_FIELD)
                .gt(since)
                .and(DataMismatch.ACKNOWLEDGE_FIELD)
                .is(false)
        );

        return mongoTemplate.count(query, DataMismatch.class);
    }
}
