package ru.yandex.market.clickhouse.dealer.state;

import java.time.Instant;
import java.util.Objects;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 01/02/2018
 */
public class PartitionClickHouseState {
    private final PartitionYtState transferredYtState;
    private final Instant transferredDate;
    private final Instant checkDate;

    public PartitionClickHouseState(PartitionYtState transferredYtState, Instant transferredDate, Instant checkDate) {
        this.transferredYtState = transferredYtState;
        this.transferredDate = transferredDate;
        this.checkDate = checkDate;
    }

    public PartitionYtState getTransferredYtState() {
        return transferredYtState;
    }

    public Instant getTransferredDate() {
        return transferredDate;
    }

    public Instant getCheckDate() {
        return checkDate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PartitionClickHouseState that = (PartitionClickHouseState) o;
        return Objects.equals(transferredYtState, that.transferredYtState) &&
            Objects.equals(transferredDate, that.transferredDate) &&
            Objects.equals(checkDate, that.checkDate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(transferredYtState, transferredDate, checkDate);
    }

    @Override
    public String toString() {
        return "PartitionClickHouseState{" +
            "transferredYtState=" + transferredYtState +
            ", transferredDate=" + transferredDate +
            ", checkDate=" + checkDate +
            '}';
    }
}
