package ru.yandex.market.clickhouse.dealer.state;

import java.time.Instant;
import java.util.Objects;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 01/02/2018
 */
public class PartitionYtState {
    private final Instant modificationDate;
    private final long rowCount;
    private final Instant checkDate;
    private final long revision;

    public PartitionYtState(Instant modificationDate, long rowCount, Instant checkDate, long revision) {
        this.modificationDate = modificationDate;
        this.rowCount = rowCount;
        this.checkDate = checkDate;
        this.revision = revision;
    }

    public long getRowCount() {
        return rowCount;
    }

    public Instant getModificationDate() {
        return modificationDate;
    }

    public Instant getCheckDate() {
        return checkDate;
    }

    public long getRevision() {
        return revision;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PartitionYtState ytState = (PartitionYtState) o;
        return rowCount == ytState.rowCount &&
            revision == ytState.revision &&
            Objects.equals(modificationDate, ytState.modificationDate) &&
            Objects.equals(checkDate, ytState.checkDate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(modificationDate, rowCount, checkDate, revision);
    }

    @Override
    public String toString() {
        return "PartitionYtState{" +
            "modificationDate=" + modificationDate +
            ", rowCount=" + rowCount +
            ", checkDate=" + checkDate +
            ", revision=" + revision +
            '}';
    }
}
