package ru.yandex.market.clickhouse.dealer.tm;

import com.google.gson.annotations.SerializedName;

import java.util.List;
import java.util.Objects;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 23/03/2018
 */
public class TmClickHouseClusterOptions {
    @SerializedName("cluster_name")
    private final String clusterName;

    @SerializedName("http_port")
    private final int httpPort;

    @SerializedName("seed_hosts")
    private final List<String> seedHosts;

    public TmClickHouseClusterOptions(String clusterName, int httpPort, List<String> seedHosts) {
        this.clusterName = clusterName;
        this.httpPort = httpPort;
        this.seedHosts = seedHosts;
    }

    @Override
    public String toString() {
        return "TmClickHouseClusterOptions{" +
            "clusterName='" + clusterName + '\'' +
            ", httpPort=" + httpPort +
            ", seedHosts=" + seedHosts +
            '}';
    }

    public String getClusterName() {
        return clusterName;
    }

    public int getHttpPort() {
        return httpPort;
    }

    public List<String> getSeedHosts() {
        return seedHosts;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TmClickHouseClusterOptions options = (TmClickHouseClusterOptions) o;
        return httpPort == options.httpPort &&
            Objects.equals(clusterName, options.clusterName) &&
            Objects.equals(seedHosts, options.seedHosts);
    }

    @Override
    public int hashCode() {

        return Objects.hash(clusterName, httpPort, seedHosts);
    }
}
