package ru.yandex.market.clickhouse.dealer.tm;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;

import java.time.Instant;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 13/04/2018
 */
public class TmTaskState {

    private String id;

    @SerializedName("state")
    private Status status;

    @SerializedName("state_description")
    private String description;

    private Error error;

    @SerializedName("finish_time")
    private Instant finishTime;

    @SerializedName("start_time")
    private Instant startTime;

    @SerializedName("creation_time")
    private Instant creationTime;

    public TmTaskState() {
    }

    public TmTaskState(Status status, String description, Error error) {
        this.status = status;
        this.description = description;
        this.error = error;
    }

    public TmTaskState(String id, Status status, String description, Error error,
                       Instant finishTime, Instant startTime, Instant creationTime) {
        this.id = id;
        this.status = status;
        this.description = description;
        this.error = error;
        this.finishTime = finishTime;
        this.startTime = startTime;
        this.creationTime = creationTime;
    }

    public static class Error {
        private String message;
        private int code;

        @Override
        public String toString() {
            return "Error{" +
                "message='" + message + '\'' +
                ", code=" + code +
                '}';
        }
    }

    public boolean isFinished() {
        return status.equals(Status.FAILED) || status.equals(Status.COMPLETED);
    }

    public boolean isSuccess() {
        Preconditions.checkState(isFinished(), "Task not finished yet, check isFinished() first.");
        return status.equals(Status.COMPLETED);
    }

    public Status getStatus() {
        return status;
    }

    public String getDescription() {
        return description;
    }

    public Error getError() {
        return error;
    }

    public Instant getFinishTime() {
        return finishTime;
    }

    public Instant getStartTime() {
        return startTime;
    }

    public Instant getCreationTime() {
        return creationTime;
    }

    public enum Status {
        @SerializedName("failed")
        FAILED,
        @SerializedName("pending")
        PENDING,
        @SerializedName("completed")
        COMPLETED,
        @SerializedName("running")
        RUNNING,
    }

    @Override
    public String toString() {
        return "TmTaskState{" +
            "id='" + id + '\'' +
            ", status=" + status +
            ", description='" + description + '\'' +
            ", error=" + error +
            ", finishTime=" + finishTime +
            ", startTime=" + startTime +
            ", creationTime=" + creationTime +
            '}';
    }
}
