package ru.yandex.market.clickphite;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 29/12/14
 */
public class ClickHouseTable {

    private final String database;
    private final String name;
    private final String fullName;

    private final ProcessStatus firstDataProcessStatus = new ProcessStatus();
    private final ProcessStatus delayProcessStatus = new ProcessStatus();

    private volatile int tableDataStartSeconds = -1;

    private ClickHouseTable(String database, String name) {
        this.database = database;
        this.name = name;
        fullName = database + "." + name;
    }

    public String getFullName() {
        return fullName;
    }

    public String getDatabase() {
        return database;
    }

    public String getName() {
        return name;
    }

    public void setTableDataStartSeconds(int tableDataStartSeconds) {
        this.tableDataStartSeconds = tableDataStartSeconds;
    }

    public ProcessStatus getFirstDataProcessStatus() {
        return firstDataProcessStatus;
    }

    public int getTableDataStartSeconds() {
        return tableDataStartSeconds;
    }

    @Override
    public String toString() {
        return getFullName();
    }

    public ProcessStatus getDelayProcessStatus() {
        return delayProcessStatus;
    }

    public static ClickHouseTable create(String name, String defaultDatabase) {
        boolean containsDatabase = name.contains(".");
        if (!containsDatabase) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(defaultDatabase), "No default database provided");
            return new ClickHouseTable(defaultDatabase, name);
        }
        String[] splits = name.split("\\.");
        Preconditions.checkArgument(splits.length == 2, "More than 2 dots in table name");
        return new ClickHouseTable(splits[0], splits[1]);
    }

}
