package ru.yandex.market.clickphite;

import java.util.Date;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 05/03/15
 */
public class ProcessStatus {
    private volatile boolean onAir = false;
    private volatile long lastProcessTimeMillis;
    private volatile boolean error = false;
    private volatile Exception exception = null;
    private volatile long firstErrorTimeInARowMillis = -1;

    public Exception getException() {
        return exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public boolean isOnAir() {
        return onAir;
    }

    public void setOnAir(boolean onAir) {
        this.onAir = onAir;
    }

    public boolean isError() {
        return error;
    }

    public void setError(boolean error) {
        this.error = error;

        if (error) {
            if (firstErrorTimeInARowMillis < 0) {
                firstErrorTimeInARowMillis = System.currentTimeMillis();
            }
        } else {
            firstErrorTimeInARowMillis = -1;
        }
    }

    public long getLastProcessTimeMillis() {
        return lastProcessTimeMillis;
    }

    public Date getLastProcessDate() {
        return new Date(lastProcessTimeMillis);
    }

    public void setLastProcessTimeMillis(long lastProcessTimeMillis) {
        this.lastProcessTimeMillis = lastProcessTimeMillis;
    }

    public long getFirstErrorTimeInARowMillis() {
        return firstErrorTimeInARowMillis;
    }
}
