package ru.yandex.market.clickphite;

import ru.yandex.market.clickphite.config.metric.AbstractMetricConfig;
import ru.yandex.market.clickphite.config.metric.MetricField;
import ru.yandex.market.clickphite.config.metric.MetricPeriod;
import ru.yandex.market.clickphite.config.metric.SubAggregateConfig;

import java.util.List;

/**
 * Сущность, по которой можно построить запрос в кликхаус с помощью {@link QueryBuilder}.
 *
 * @author Anton Sukhonosenko <a href="mailto:algebraic@yandex-team.ru"></a>
 * @date 20.09.17
 */
public interface Queriable {
    MetricPeriod getPeriod();

    ClickHouseTable getTable();

    String getFilter();

    SubAggregateConfig getSubAggregate();

    List<? extends MetricField> getSplits();

    List<AbstractMetricConfig<?>> getMetricConfigs();

    int getMovingWindowPeriods();
}
