package ru.yandex.market.clickphite;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 29/12/14
 */
public class TableCountKey implements Comparable<TableCountKey> {
    private final int timestamp;
    private final String name;

    public TableCountKey(int timestamp, String name) {
        this.timestamp = timestamp;
        this.name = name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        TableCountKey that = (TableCountKey) o;

        if (timestamp != that.timestamp) {
            return false;
        }
        if (name != null ? !name.equals(that.name) : that.name != null) {
            return false;
        }

        return true;
    }

    public int getTimestamp() {
        return timestamp;
    }

    public String getName() {
        return name;
    }

    @Override
    public int hashCode() {
        int result = timestamp;
        result = 31 * result + (name != null ? name.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        //TODO
        return "TableCountKey{" +
            "timestamp=" + timestamp +
            ", name='" + name + '\'' +
            '}';
    }

    @Override
    public int compareTo(TableCountKey o) {
        return Integer.compare(timestamp, o.timestamp);
    }
}
