package ru.yandex.market.clickphite;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntSet;

import java.util.Iterator;
import java.util.Map;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 04/03/15
 */
public class TableCounts implements Iterable<Map.Entry<Integer, Integer>> {

    private Int2IntMap map = new Int2IntOpenHashMap();
    private final ClickHouseTable table;

    public TableCounts(ClickHouseTable table) {
        this.table = table;
        map.defaultReturnValue(-1);
    }

    public int get(int timestampSeconds) {
        return map.get(timestampSeconds);
    }

    public Iterator<Map.Entry<Integer, Integer>> timestampToCountIterator() {
        return map.entrySet().iterator();
    }

    public IntSet getTimestamps() {
        return map.keySet();
    }

    public boolean isEmpty() {
        return map.isEmpty();
    }

    public int size() {
        return map.size();
    }

    @Override
    public Iterator<Map.Entry<Integer, Integer>> iterator() {
        return timestampToCountIterator();
    }

    public void put(int timestampSeconds, int count) {
        map.put(timestampSeconds, count);
    }

    public ClickHouseTable getTable() {
        return table;
    }
}
