package ru.yandex.market.clickphite.config;

import ru.yandex.market.clickphite.config.metric.GraphiteMetricConfig;
import ru.yandex.market.clickphite.config.metric.SolomonSensorConfig;
import ru.yandex.market.clickphite.config.metric.StatfaceReportConfig;
import ru.yandex.market.clickphite.dashboard.DashboardContext;
import ru.yandex.market.clickphite.metric.MetricContext;
import ru.yandex.market.clickphite.monitoring.MonitoringContext;

import java.io.File;
import java.util.Collections;
import java.util.List;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 19/01/15
 */
public class ConfigFile {

    private final File file;
    private volatile long knownModificationTime;

    private volatile List<StatfaceReportConfig> statfaceReportConfigs = Collections.emptyList();
    private volatile List<GraphiteMetricConfig> graphiteMetricConfigs = Collections.emptyList();
    private volatile List<SolomonSensorConfig> solomonSensorConfigs = Collections.emptyList();

    private volatile List<MetricContext> metricContexts = Collections.emptyList();
    private volatile List<DashboardContext> dashboardContexts = Collections.emptyList();
    private volatile List<MonitoringContext> monitoringContexts = Collections.emptyList();
    private volatile boolean valid;

    public ConfigFile(File file) {
        this.file = file;
        knownModificationTime = -1;
    }

    public String getName() {
        return file.getPath();
    }

    public File getFile() {
        return file;
    }

    public long getKnownModificationTime() {
        return knownModificationTime;
    }

    public List<MetricContext> getMetricContexts() {
        return metricContexts;
    }

    public void setKnownModificationTime(long knownModificationTime) {
        this.knownModificationTime = knownModificationTime;
    }

    public void setMetricContexts(List<MetricContext> metricContexts) {
        this.metricContexts = metricContexts;
    }

    public List<DashboardContext> getDashboardContexts() {
        return dashboardContexts;
    }

    public void setDashboardContexts(List<DashboardContext> dashboardContexts) {
        this.dashboardContexts = dashboardContexts;
    }

    public List<MonitoringContext> getMonitoringContexts() {
        return monitoringContexts;
    }

    public void setMonitoringContexts(List<MonitoringContext> monitoringContexts) {
        this.monitoringContexts = monitoringContexts;
    }

    public List<StatfaceReportConfig> getStatfaceReportConfigs() {
        return statfaceReportConfigs;
    }

    public void setStatfaceReportConfigs(List<StatfaceReportConfig> statfaceReportConfigs) {
        this.statfaceReportConfigs = statfaceReportConfigs;
    }

    public List<GraphiteMetricConfig> getGraphiteMetricConfigs() {
        return graphiteMetricConfigs;
    }

    public void setGraphiteMetricConfigs(List<GraphiteMetricConfig> graphiteMetricConfigs) {
        this.graphiteMetricConfigs = graphiteMetricConfigs;
    }

    public List<SolomonSensorConfig> getSolomonSensorConfigs() {
        return solomonSensorConfigs;
    }

    public void setSolomonSensorConfigs(List<SolomonSensorConfig> solomonSensorConfigs) {
        this.solomonSensorConfigs = solomonSensorConfigs;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public boolean isValid() {
        return valid;
    }

    @Override
    public String toString() {
        return getName();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        ConfigFile that = (ConfigFile) o;

        return file.equals(that.file);
    }

    @Override
    public int hashCode() {
        return file.hashCode();
    }
}
