package ru.yandex.market.clickphite.config.dashboard;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 15/05/15
 */
public class DashboardConfig {
    private String metric;
    private String id;
    private String title;
    private List<String> sort = Collections.emptyList();
    private int graphsInRow = 1;
    private Set<String> tags = Collections.emptySet();

    public DashboardConfig() {
    }

    public DashboardConfig(String metric, String id, String title, List<String> sort,
                           int graphsInRow, Set<String> tags) {
        this.metric = metric;
        this.id = id;
        this.title = title;
        this.sort = sort;
        this.graphsInRow = graphsInRow;
        this.tags = tags;
    }

    public String getId() {
        return id;
    }

    public String getTitle() {
        return title;
    }

    public List<String> getSort() {
        return sort;
    }

    public int getGraphsInRow() {
        return graphsInRow;
    }

    public Set<String> getTags() {
        return tags;
    }

    public String getMetric() {
        return metric;
    }

    public Object[] keyArray() {
        Collections.sort(sort);
        return new Object[]{
            metric, id, title, graphsInRow, tags, sort
        };
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(keyArray());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DashboardConfig)) {
            return false;
        }

        DashboardConfig that = (DashboardConfig) obj;
        return Arrays.equals(this.keyArray(), that.keyArray());
    }
}
