package ru.yandex.market.clickphite.config.metric;

import com.google.common.base.Preconditions;
import ru.yandex.market.clickphite.ClickHouseTable;
import ru.yandex.market.clickphite.Queriable;
import ru.yandex.market.clickphite.metric.MetricStorage;

import java.util.Collections;
import java.util.List;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 24/02/16
 */
public abstract class AbstractMetricConfig<T extends AbstractMetricConfig> implements Queriable {
    protected String tableName;
    protected ClickHouseTable table;
    protected MetricPeriod period;
    protected String filter;
    protected SubAggregateConfig subAggregate;
    protected double valueOnNan = Double.NaN;
    protected int movingWindowPeriods = 1;

    protected AbstractMetricConfig() {
    }

    protected AbstractMetricConfig(AbstractMetricConfig<T> other) {
        this.tableName = other.tableName;
        this.table = other.table;
        this.period = other.period;
        this.filter = other.filter;
        this.subAggregate = other.subAggregate;
        this.valueOnNan = other.valueOnNan;
        this.movingWindowPeriods = other.movingWindowPeriods;
    }

    @Override
    public ClickHouseTable getTable() {
        Preconditions.checkState(table != null);
        return table;
    }

    public void setTable(ClickHouseTable table) {
        this.table = table;
    }

    public abstract T copy();

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public MetricPeriod getPeriod() {
        return period;
    }

    public void setPeriod(MetricPeriod period) {
        this.period = period;
    }

    @Override
    public SubAggregateConfig getSubAggregate() {
        return subAggregate;
    }

    @Override
    public String getFilter() {
        return filter;
    }

    public double getValueOnNan() {
        return valueOnNan;
    }

    public void setValueOnNan(double valueOnNan) {
        this.valueOnNan = valueOnNan;
    }

    public abstract List<? extends MetricField> getFields();

    @Override
    public abstract List<? extends MetricField> getSplits();

    public void setSubAggregate(SubAggregateConfig subAggregate) {
        this.subAggregate = subAggregate;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Override
    public List<AbstractMetricConfig<?>> getMetricConfigs() {
        return Collections.singletonList(this);
    }

    public abstract MetricStorage getStorage();

    public abstract MetricType getType();

    public abstract List<String> getQuantiles();

    @Override
    public int getMovingWindowPeriods() {
        return movingWindowPeriods;
    }
}
