package ru.yandex.market.clickphite.config.metric;

import java.util.List;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 24/02/16
 */
public interface MetricField {

    String getName();

    default String getClickHouseName() {
        return getName().replace('-', '_');
    }

    String getField();

    default MetricType getType() {
        return MetricType.SIMPLE;
    }

    default List<String> getQuantiles() {
        throw new UnsupportedOperationException();
    }

}
