package ru.yandex.market.clickphite.config.metric;

import java.util.Objects;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 17/01/15
 */
public class MetricSplit implements MetricField {
    private String name;
    private String field;

    public MetricSplit(String name, String field) {
        this.name = name;
        this.field = field;
    }

    @Override
    public String getName() {
        return name;
    }

    public String getSplitVariable() {
        return "${" + name + "}";
    }

    @Override
    public String getField() {
        return field;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MetricSplit that = (MetricSplit) o;
        return Objects.equals(name, that.name) && Objects.equals(field, that.field);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, field);
    }
}


